/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimpleElementValue
extends ElementValue {
    private int index;

    public SimpleElementValue(int n, int n2, ConstantPool constantPool) {
        super(n, constantPool);
        this.index = n2;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        int n = super.getType();
        dataOutputStream.writeByte(n);
        switch (n) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dataOutputStream.writeShort(this.getIndex());
                break;
            }
            default: {
                throw new ClassFormatException("SimpleElementValue doesnt know how to write out type " + n);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public boolean getValueBoolean() {
        if (super.getType() != 90) {
            throw new IllegalStateException("Dont call getValueBoolean() on a non BOOLEAN ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex());
        return constantInteger.getBytes() != 0;
    }

    public byte getValueByte() {
        if (super.getType() != 66) {
            throw new IllegalStateException("Dont call getValueByte() on a non BYTE ElementValue");
        }
        return (byte)super.getConstantPool().getConstantInteger(this.getIndex()).getBytes();
    }

    public char getValueChar() {
        if (super.getType() != 67) {
            throw new IllegalStateException("Dont call getValueChar() on a non CHAR ElementValue");
        }
        return (char)super.getConstantPool().getConstantInteger(this.getIndex()).getBytes();
    }

    public double getValueDouble() {
        if (super.getType() != 68) {
            throw new IllegalStateException("Dont call getValueDouble() on a non DOUBLE ElementValue");
        }
        ConstantDouble constantDouble = (ConstantDouble)super.getConstantPool().getConstant(this.getIndex());
        return constantDouble.getBytes();
    }

    public float getValueFloat() {
        if (super.getType() != 70) {
            throw new IllegalStateException("Dont call getValueFloat() on a non FLOAT ElementValue");
        }
        ConstantFloat constantFloat = (ConstantFloat)super.getConstantPool().getConstant(this.getIndex());
        return constantFloat.getBytes();
    }

    public int getValueInt() {
        if (super.getType() != 73) {
            throw new IllegalStateException("Dont call getValueInt() on a non INT ElementValue");
        }
        return super.getConstantPool().getConstantInteger(this.getIndex()).getBytes();
    }

    public long getValueLong() {
        if (super.getType() != 74) {
            throw new IllegalStateException("Dont call getValueLong() on a non LONG ElementValue");
        }
        ConstantLong constantLong = (ConstantLong)super.getConstantPool().getConstant(this.getIndex());
        return constantLong.getBytes();
    }

    public short getValueShort() {
        if (super.getType() != 83) {
            throw new IllegalStateException("Dont call getValueShort() on a non SHORT ElementValue");
        }
        ConstantInteger constantInteger = (ConstantInteger)super.getConstantPool().getConstant(this.getIndex());
        return (short)constantInteger.getBytes();
    }

    public String getValueString() {
        if (super.getType() != 115) {
            throw new IllegalStateException("Dont call getValueString() on a non STRING ElementValue");
        }
        return super.getConstantPool().getConstantUtf8(this.getIndex()).getBytes();
    }

    public void setIndex(int n) {
        this.index = n;
    }

    @Override
    public String stringifyValue() {
        ConstantPool constantPool = super.getConstantPool();
        int n = super.getType();
        switch (n) {
            case 73: {
                return Integer.toString(constantPool.getConstantInteger(this.getIndex()).getBytes());
            }
            case 74: {
                ConstantLong constantLong = constantPool.getConstant(this.getIndex(), (byte)5, ConstantLong.class);
                return Long.toString(constantLong.getBytes());
            }
            case 68: {
                ConstantDouble constantDouble = constantPool.getConstant(this.getIndex(), (byte)6, ConstantDouble.class);
                return Double.toString(constantDouble.getBytes());
            }
            case 70: {
                ConstantFloat constantFloat = constantPool.getConstant(this.getIndex(), (byte)4, ConstantFloat.class);
                return Float.toString(constantFloat.getBytes());
            }
            case 83: {
                ConstantInteger constantInteger = constantPool.getConstantInteger(this.getIndex());
                return Integer.toString(constantInteger.getBytes());
            }
            case 66: {
                ConstantInteger constantInteger = constantPool.getConstantInteger(this.getIndex());
                return Integer.toString(constantInteger.getBytes());
            }
            case 67: {
                ConstantInteger constantInteger = constantPool.getConstantInteger(this.getIndex());
                return String.valueOf((char)constantInteger.getBytes());
            }
            case 90: {
                ConstantInteger constantInteger = constantPool.getConstantInteger(this.getIndex());
                if (constantInteger.getBytes() == 0) {
                    return "false";
                }
                return "true";
            }
            case 115: {
                return constantPool.getConstantUtf8(this.getIndex()).getBytes();
            }
        }
        throw new IllegalStateException("SimpleElementValue class does not know how to stringify type " + n);
    }

    @Override
    public String toString() {
        return this.stringifyValue();
    }
}

