/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class Signature
extends Attribute {
    private int signatureIndex;

    private static boolean identStart(int n) {
        return n == 84 || n == 76;
    }

    public static boolean isActualParameterList(String string) {
        return string.startsWith("L") && string.endsWith(">;");
    }

    public static boolean isFormalParameterList(String string) {
        return string.startsWith("<") && string.indexOf(58) > 0;
    }

    private static void matchGJIdent(MyByteArrayInputStream myByteArrayInputStream, StringBuilder stringBuilder) {
        Signature.matchIdent(myByteArrayInputStream, stringBuilder);
        int n = myByteArrayInputStream.read();
        if (n == 60 || n == 40) {
            stringBuilder.append((char)n);
            Signature.matchGJIdent(myByteArrayInputStream, stringBuilder);
            while ((n = myByteArrayInputStream.read()) != 62 && n != 41) {
                if (n == -1) {
                    throw new IllegalArgumentException("Illegal signature: " + myByteArrayInputStream.getData() + " reaching EOF");
                }
                stringBuilder.append(", ");
                myByteArrayInputStream.unread();
                Signature.matchGJIdent(myByteArrayInputStream, stringBuilder);
            }
            stringBuilder.append((char)n);
        } else {
            myByteArrayInputStream.unread();
        }
        n = myByteArrayInputStream.read();
        if (Signature.identStart(n)) {
            myByteArrayInputStream.unread();
            Signature.matchGJIdent(myByteArrayInputStream, stringBuilder);
        } else if (n == 41) {
            myByteArrayInputStream.unread();
        } else if (n != 59) {
            throw new IllegalArgumentException("Illegal signature: " + myByteArrayInputStream.getData() + " read " + (char)n);
        }
    }

    private static void matchIdent(MyByteArrayInputStream myByteArrayInputStream, StringBuilder stringBuilder) {
        int n = myByteArrayInputStream.read();
        if (n == -1) {
            throw new IllegalArgumentException("Illegal signature: " + myByteArrayInputStream.getData() + " no ident, reaching EOF");
        }
        if (!Signature.identStart(n)) {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = 1;
            while (Character.isJavaIdentifierPart((char)n)) {
                stringBuilder2.append((char)n);
                ++n2;
                n = myByteArrayInputStream.read();
            }
            if (n == 58) {
                int n3 = "Ljava/lang/Object".length();
                long l = myByteArrayInputStream.skip(n3);
                if (l != (long)n3) {
                    throw new IllegalStateException(String.format("Unexpected skip: expected=%,d, actual=%,d", n3, l));
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                n = myByteArrayInputStream.read();
                myByteArrayInputStream.unread();
            } else {
                for (int i = 0; i < n2; ++i) {
                    myByteArrayInputStream.unread();
                }
            }
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        n = myByteArrayInputStream.read();
        do {
            stringBuilder3.append((char)n);
        } while ((n = myByteArrayInputStream.read()) != -1 && (Character.isJavaIdentifierPart((char)n) || n == 47));
        stringBuilder.append(Utility.pathToPackage(stringBuilder3.toString()));
        if (n != -1) {
            myByteArrayInputStream.unread();
        }
    }

    public static String translate(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Signature.matchGJIdent(new MyByteArrayInputStream(string), stringBuilder);
        return stringBuilder.toString();
    }

    Signature(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), constantPool);
    }

    public Signature(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)10, n, Args.require(n2, 2, "Signature length attribute"), constantPool);
        this.signatureIndex = n3;
        Objects.requireNonNull(constantPool.getConstantUtf8(n3), "constantPool.getConstantUtf8(signatureIndex)");
    }

    public Signature(Signature signature) {
        this(signature.getNameIndex(), signature.getLength(), signature.getSignatureIndex(), signature.getConstantPool());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSignature(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (Attribute)this.clone();
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.signatureIndex);
    }

    public String getSignature() {
        return super.getConstantPool().getConstantUtf8(this.signatureIndex).getBytes();
    }

    public int getSignatureIndex() {
        return this.signatureIndex;
    }

    public void setSignatureIndex(int n) {
        this.signatureIndex = n;
    }

    @Override
    public String toString() {
        return "Signature: " + this.getSignature();
    }

    private static final class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(String string) {
            super(string.getBytes(StandardCharsets.UTF_8));
        }

        String getData() {
            return new String(this.buf, StandardCharsets.UTF_8);
        }

        void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }
}

