/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NestHost
extends Attribute {
    private int hostClassIndex;

    NestHost(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, 0, constantPool);
        this.hostClassIndex = dataInput.readUnsignedShort();
    }

    public NestHost(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)26, n, n2, constantPool);
        this.hostClassIndex = Args.requireU2(n3, "hostClassIndex");
    }

    public NestHost(NestHost nestHost) {
        this(nestHost.getNameIndex(), nestHost.getLength(), nestHost.getHostClassIndex(), nestHost.getConstantPool());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitNestHost(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        NestHost nestHost = (NestHost)this.clone();
        nestHost.setConstantPool(constantPool);
        return nestHost;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.hostClassIndex);
    }

    public int getHostClassIndex() {
        return this.hostClassIndex;
    }

    public void setHostClassIndex(int n) {
        this.hostClassIndex = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NestHost: ");
        String string = super.getConstantPool().getConstantString(this.hostClassIndex, (byte)7);
        stringBuilder.append(Utility.compactClassName(string, false));
        return stringBuilder.toString();
    }
}

