/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleMainClass
extends Attribute {
    private int mainClassIndex;

    ModuleMainClass(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, 0, constantPool);
        this.mainClassIndex = dataInput.readUnsignedShort();
    }

    public ModuleMainClass(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)26, n, n2, constantPool);
        this.mainClassIndex = Args.requireU2(n3, "mainClassIndex");
    }

    public ModuleMainClass(ModuleMainClass moduleMainClass) {
        this(moduleMainClass.getNameIndex(), moduleMainClass.getLength(), moduleMainClass.getHostClassIndex(), moduleMainClass.getConstantPool());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleMainClass(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ModuleMainClass moduleMainClass = (ModuleMainClass)this.clone();
        moduleMainClass.setConstantPool(constantPool);
        return moduleMainClass;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.mainClassIndex);
    }

    public int getHostClassIndex() {
        return this.mainClassIndex;
    }

    public void setHostClassIndex(int n) {
        this.mainClassIndex = n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ModuleMainClass: ");
        String string = super.getConstantPool().getConstantString(this.mainClassIndex, (byte)7);
        stringBuilder.append(Utility.compactClassName(string, false));
        return stringBuilder.toString();
    }
}

