/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class LocalVariableTable
extends Attribute
implements Iterable<LocalVariable> {
    private LocalVariable[] localVariableTable;

    LocalVariableTable(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (LocalVariable[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.localVariableTable = new LocalVariable[n3];
        for (int i = 0; i < n3; ++i) {
            this.localVariableTable[i] = new LocalVariable(dataInput, constantPool);
        }
    }

    public LocalVariableTable(int n, int n2, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)5, n, n2, constantPool);
        this.localVariableTable = localVariableArray != null ? localVariableArray : LocalVariable.EMPTY_ARRAY;
        Args.requireU2(this.localVariableTable.length, "localVariableTable.length");
    }

    public LocalVariableTable(LocalVariableTable localVariableTable) {
        this(localVariableTable.getNameIndex(), localVariableTable.getLength(), localVariableTable.getLocalVariableTable(), localVariableTable.getConstantPool());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTable(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        LocalVariableTable localVariableTable = (LocalVariableTable)this.clone();
        localVariableTable.localVariableTable = new LocalVariable[this.localVariableTable.length];
        for (int i = 0; i < this.localVariableTable.length; ++i) {
            localVariableTable.localVariableTable[i] = this.localVariableTable[i].copy();
        }
        localVariableTable.setConstantPool(constantPool);
        return localVariableTable;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.localVariableTable.length);
        for (LocalVariable localVariable : this.localVariableTable) {
            localVariable.dump(dataOutputStream);
        }
    }

    @Deprecated
    public final LocalVariable getLocalVariable(int n) {
        for (LocalVariable localVariable : this.localVariableTable) {
            if (localVariable.getIndex() != n) continue;
            return localVariable;
        }
        return null;
    }

    public final LocalVariable getLocalVariable(int n, int n2) {
        for (LocalVariable localVariable : this.localVariableTable) {
            if (localVariable.getIndex() != n) continue;
            int n3 = localVariable.getStartPC();
            int n4 = n3 + localVariable.getLength();
            if (n2 < n3 || n2 > n4) continue;
            return localVariable;
        }
        return null;
    }

    public final LocalVariable[] getLocalVariableTable() {
        return this.localVariableTable;
    }

    public final int getTableLength() {
        return this.localVariableTable == null ? 0 : this.localVariableTable.length;
    }

    @Override
    public Iterator<LocalVariable> iterator() {
        return Arrays.asList(this.localVariableTable).iterator();
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.localVariableTable = localVariableArray;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.localVariableTable.length; ++i) {
            stringBuilder.append(this.localVariableTable[i]);
            if (i >= this.localVariableTable.length - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

