/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LocalVariable
implements Cloneable,
Node {
    static final LocalVariable[] EMPTY_ARRAY = new LocalVariable[0];
    private int startPc;
    private int length;
    private int nameIndex;
    private int signatureIndex;
    private int index;
    private ConstantPool constantPool;
    private final int origIndex;

    LocalVariable(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), constantPool);
    }

    public LocalVariable(int n, int n2, int n3, int n4, int n5, ConstantPool constantPool) {
        this(n, n2, n3, n4, n5, constantPool, n5);
    }

    public LocalVariable(int n, int n2, int n3, int n4, int n5, ConstantPool constantPool, int n6) {
        this.startPc = Args.requireU2(n, "startPc");
        this.length = Args.requireU2(n2, "length");
        this.nameIndex = Args.requireU2(n3, "nameIndex");
        this.signatureIndex = Args.requireU2(n4, "signatureIndex");
        this.index = Args.requireU2(n5, "index");
        this.origIndex = Args.requireU2(n6, "origIndex");
        this.constantPool = constantPool;
    }

    public LocalVariable(LocalVariable localVariable) {
        this(localVariable.getStartPC(), localVariable.getLength(), localVariable.getNameIndex(), localVariable.getSignatureIndex(), localVariable.getIndex(), localVariable.getConstantPool());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariable(this);
    }

    public LocalVariable copy() {
        try {
            return (LocalVariable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.startPc);
        dataOutputStream.writeShort(this.length);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.signatureIndex);
        dataOutputStream.writeShort(this.index);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        return this.constantPool.getConstantUtf8(this.nameIndex).getBytes();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public int getOrigIndex() {
        return this.origIndex;
    }

    public String getSignature() {
        return this.constantPool.getConstantUtf8(this.signatureIndex).getBytes();
    }

    public int getSignatureIndex() {
        return this.signatureIndex;
    }

    public int getStartPC() {
        return this.startPc;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public void setSignatureIndex(int n) {
        this.signatureIndex = n;
    }

    public void setStartPC(int n) {
        this.startPc = n;
    }

    public String toString() {
        return this.toStringShared(false);
    }

    String toStringShared(boolean bl) {
        String string = this.getName();
        String string2 = Utility.signatureToString(this.getSignature(), false);
        String string3 = "LocalVariable" + (bl ? "Types" : "");
        return string3 + "(startPc = " + this.startPc + ", length = " + this.length + ", index = " + this.index + ":" + string2 + " " + string + ")";
    }
}

