/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumber
implements Cloneable,
Node {
    static final LineNumber[] EMPTY_ARRAY = new LineNumber[0];
    private int startPc;
    private int lineNumber;

    LineNumber(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public LineNumber(int n, int n2) {
        this.startPc = Args.requireU2(n, "startPc");
        this.lineNumber = Args.requireU2(n2, "lineNumber");
    }

    public LineNumber(LineNumber lineNumber) {
        this(lineNumber.getStartPC(), lineNumber.getLineNumber());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLineNumber(this);
    }

    public LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.startPc);
        dataOutputStream.writeShort(this.lineNumber);
    }

    public int getLineNumber() {
        return this.lineNumber & 0xFFFF;
    }

    public int getStartPC() {
        return this.startPc & 0xFFFF;
    }

    public void setLineNumber(int n) {
        this.lineNumber = (short)n;
    }

    public void setStartPC(int n) {
        this.startPc = (short)n;
    }

    public String toString() {
        return "LineNumber(" + this.getStartPC() + ", " + this.getLineNumber() + ")";
    }
}

