/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class FieldOrMethod
extends AccessFlags
implements Cloneable,
Node {
    @Deprecated
    protected int name_index;
    @Deprecated
    protected int signature_index;
    @Deprecated
    protected Attribute[] attributes;
    @Deprecated
    protected int attributes_count;
    private AnnotationEntry[] annotationEntries;
    @Deprecated
    protected ConstantPool constant_pool;
    private String signatureAttributeString;
    private boolean searchedForSignatureAttribute;

    FieldOrMethod() {
    }

    protected FieldOrMethod(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), null, constantPool);
        int n = dataInput.readUnsignedShort();
        this.attributes = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = Attribute.readAttribute(dataInput, constantPool);
        }
        this.attributes_count = n;
    }

    @Deprecated
    protected FieldOrMethod(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this((DataInput)dataInputStream, constantPool);
    }

    protected FieldOrMethod(FieldOrMethod fieldOrMethod) {
        this(fieldOrMethod.getAccessFlags(), fieldOrMethod.getNameIndex(), fieldOrMethod.getSignatureIndex(), fieldOrMethod.getAttributes(), fieldOrMethod.getConstantPool());
    }

    protected FieldOrMethod(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n);
        this.name_index = n2;
        this.signature_index = n3;
        this.constant_pool = constantPool;
        this.setAttributes(attributeArray);
    }

    protected FieldOrMethod copy_(ConstantPool constantPool) {
        try {
            FieldOrMethod fieldOrMethod = (FieldOrMethod)this.clone();
            fieldOrMethod.constant_pool = constantPool;
            fieldOrMethod.attributes = new Attribute[this.attributes.length];
            fieldOrMethod.attributes_count = this.attributes_count;
            for (int i = 0; i < this.attributes.length; ++i) {
                fieldOrMethod.attributes[i] = this.attributes[i].copy(this.constant_pool);
            }
            return fieldOrMethod;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(super.getAccessFlags());
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
        dataOutputStream.writeShort(this.attributes_count);
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                attribute.dump(dataOutputStream);
            }
        }
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.annotationEntries == null) {
            this.annotationEntries = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotationEntries;
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final String getGenericSignature() {
        if (!this.searchedForSignatureAttribute) {
            boolean bl = false;
            for (int i = 0; !bl && i < this.attributes.length; ++i) {
                if (!(this.attributes[i] instanceof Signature)) continue;
                this.signatureAttributeString = ((Signature)this.attributes[i]).getSignature();
                bl = true;
            }
            this.searchedForSignatureAttribute = true;
        }
        return this.signatureAttributeString;
    }

    public final String getName() {
        return this.constant_pool.getConstantUtf8(this.name_index).getBytes();
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final String getSignature() {
        return this.constant_pool.getConstantUtf8(this.signature_index).getBytes();
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
        this.attributes_count = attributeArray != null ? attributeArray.length : 0;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public final void setSignatureIndex(int n) {
        this.signature_index = n;
    }
}

