/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class ElementValuePair {
    static final ElementValuePair[] EMPTY_ARRAY = new ElementValuePair[0];
    private final ElementValue elementValue;
    private final ConstantPool constantPool;
    private final int elementNameIndex;

    public ElementValuePair(int n, ElementValue elementValue, ConstantPool constantPool) {
        this.elementValue = elementValue;
        this.elementNameIndex = n;
        this.constantPool = constantPool;
    }

    protected void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.elementNameIndex);
        this.elementValue.dump(dataOutputStream);
    }

    public int getNameIndex() {
        return this.elementNameIndex;
    }

    public String getNameString() {
        return this.constantPool.getConstantUtf8(this.elementNameIndex).getBytes();
    }

    public final ElementValue getValue() {
        return this.elementValue;
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getNameString()).append("=").append(this.getValue().toShortString());
        return stringBuilder.toString();
    }
}

