/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantModule
extends Constant
implements ConstantObject {
    private int nameIndex;

    public ConstantModule(ConstantModule constantModule) {
        this(constantModule.getNameIndex());
    }

    ConstantModule(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort());
    }

    public ConstantModule(int n) {
        super((byte)19);
        this.nameIndex = n;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantModule(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeShort(this.nameIndex);
    }

    public String getBytes(ConstantPool constantPool) {
        return (String)this.getConstantValue(constantPool);
    }

    @Override
    public Object getConstantValue(ConstantPool constantPool) {
        return constantPool.getConstantUtf8(this.nameIndex).getBytes();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    @Override
    public String toString() {
        return super.toString() + "(nameIndex = " + this.nameIndex + ")";
    }
}

