/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantMethodHandle
extends Constant {
    private int referenceKind;
    private int referenceIndex;

    public ConstantMethodHandle(ConstantMethodHandle constantMethodHandle) {
        this(constantMethodHandle.getReferenceKind(), constantMethodHandle.getReferenceIndex());
    }

    ConstantMethodHandle(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedByte(), dataInput.readUnsignedShort());
    }

    public ConstantMethodHandle(int n, int n2) {
        super((byte)15);
        this.referenceKind = n;
        this.referenceIndex = n2;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantMethodHandle(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeByte(this.referenceKind);
        dataOutputStream.writeShort(this.referenceIndex);
    }

    public int getReferenceIndex() {
        return this.referenceIndex;
    }

    public int getReferenceKind() {
        return this.referenceKind;
    }

    public void setReferenceIndex(int n) {
        this.referenceIndex = n;
    }

    public void setReferenceKind(int n) {
        this.referenceKind = n;
    }

    @Override
    public String toString() {
        return super.toString() + "(referenceKind = " + this.referenceKind + ", referenceIndex = " + this.referenceIndex + ")";
    }
}

