/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Code
extends Attribute {
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private CodeException[] exceptionTable;
    private Attribute[] attributes;

    public Code(Code code) {
        this(code.getNameIndex(), code.getLength(), code.getMaxStack(), code.getMaxLocals(), code.getCode(), code.getExceptionTable(), code.getAttributes(), code.getConstantPool());
    }

    Code(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), null, null, null, constantPool);
        int n3;
        int n4 = Args.requireU4(dataInput.readInt(), 1, "Code length attribute");
        this.code = new byte[n4];
        dataInput.readFully(this.code);
        int n5 = dataInput.readUnsignedShort();
        this.exceptionTable = new CodeException[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            this.exceptionTable[n3] = new CodeException(dataInput);
        }
        n3 = dataInput.readUnsignedShort();
        this.attributes = new Attribute[n3];
        for (int i = 0; i < n3; ++i) {
            this.attributes[i] = Attribute.readAttribute(dataInput, constantPool);
        }
        super.setLength(n2);
    }

    public Code(int n, int n2, int n3, int n4, byte[] byArray, CodeException[] codeExceptionArray, Attribute[] attributeArray, ConstantPool constantPool) {
        super((byte)2, n, n2, constantPool);
        this.maxStack = Args.requireU2(n3, "maxStack");
        this.maxLocals = Args.requireU2(n4, "maxLocals");
        this.code = byArray != null ? byArray : Const.EMPTY_BYTE_ARRAY;
        this.exceptionTable = codeExceptionArray != null ? codeExceptionArray : CodeException.EMPTY_CODE_EXCEPTION_ARRAY;
        Args.requireU2(this.exceptionTable.length, "exceptionTable.length");
        this.attributes = attributeArray != null ? attributeArray : EMPTY_ARRAY;
        super.setLength(this.calculateLength());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCode(this);
    }

    private int calculateLength() {
        int n = 0;
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                n += attribute.getLength() + 6;
            }
        }
        return n + this.getInternalLength();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        int n;
        Code code = (Code)this.clone();
        if (this.code != null) {
            code.code = (byte[])this.code.clone();
        }
        code.setConstantPool(constantPool);
        code.exceptionTable = new CodeException[this.exceptionTable.length];
        for (n = 0; n < this.exceptionTable.length; ++n) {
            code.exceptionTable[n] = this.exceptionTable[n].copy();
        }
        code.attributes = new Attribute[this.attributes.length];
        for (n = 0; n < this.attributes.length; ++n) {
            code.attributes[n] = this.attributes[n].copy(constantPool);
        }
        return code;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.maxStack);
        dataOutputStream.writeShort(this.maxLocals);
        dataOutputStream.writeInt(this.code.length);
        dataOutputStream.write(this.code, 0, this.code.length);
        dataOutputStream.writeShort(this.exceptionTable.length);
        for (CodeException cloneable : this.exceptionTable) {
            cloneable.dump(dataOutputStream);
        }
        dataOutputStream.writeShort(this.attributes.length);
        for (Cloneable cloneable : this.attributes) {
            ((Attribute)cloneable).dump(dataOutputStream);
        }
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public byte[] getCode() {
        return this.code;
    }

    public CodeException[] getExceptionTable() {
        return this.exceptionTable;
    }

    private int getInternalLength() {
        return 8 + this.code.length + 2 + 8 * (this.exceptionTable == null ? 0 : this.exceptionTable.length) + 2;
    }

    public LineNumberTable getLineNumberTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LineNumberTable)) continue;
            return (LineNumberTable)attribute;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LocalVariableTable)) continue;
            return (LocalVariableTable)attribute;
        }
        return null;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray != null ? attributeArray : EMPTY_ARRAY;
        super.setLength(this.calculateLength());
    }

    public void setCode(byte[] byArray) {
        this.code = byArray != null ? byArray : Const.EMPTY_BYTE_ARRAY;
        super.setLength(this.calculateLength());
    }

    public void setExceptionTable(CodeException[] codeExceptionArray) {
        this.exceptionTable = codeExceptionArray != null ? codeExceptionArray : CodeException.EMPTY_CODE_EXCEPTION_ARRAY;
        super.setLength(this.calculateLength());
    }

    public void setMaxLocals(int n) {
        this.maxLocals = n;
    }

    public void setMaxStack(int n) {
        this.maxStack = n;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("Code(maxStack = ").append(this.maxStack).append(", maxLocals = ").append(this.maxLocals).append(", code_length = ").append(this.code.length).append(")\n").append(Utility.codeToString(this.code, super.getConstantPool(), 0, -1, bl));
        if (this.exceptionTable.length > 0) {
            stringBuilder.append("\nException handler(s) = \n").append("From\tTo\tHandler\tType\n");
            for (Cloneable cloneable : this.exceptionTable) {
                stringBuilder.append(((CodeException)cloneable).toString(super.getConstantPool(), bl)).append("\n");
            }
        }
        if (this.attributes.length > 0) {
            stringBuilder.append("\nAttribute(s) = ");
            for (Cloneable cloneable : this.attributes) {
                stringBuilder.append("\n").append(((Attribute)cloneable).getName()).append(":");
                stringBuilder.append("\n").append(cloneable);
            }
        }
        return stringBuilder.toString();
    }
}

