/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import com.sun.org.apache.bcel.internal.classfile.ElementValuePair;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnnotationEntry
implements Node {
    public static final AnnotationEntry[] EMPTY_ARRAY = new AnnotationEntry[0];
    private final int typeIndex;
    private final ConstantPool constantPool;
    private final boolean isRuntimeVisible;
    private List<ElementValuePair> elementValuePairs;

    public static AnnotationEntry[] createAnnotationEntries(Attribute[] attributeArray) {
        ArrayList<AnnotationEntry> arrayList = new ArrayList<AnnotationEntry>();
        for (Attribute attribute : attributeArray) {
            AnnotationEntry[] annotationEntryArray;
            if (!(attribute instanceof Annotations)) continue;
            for (AnnotationEntry annotationEntry : annotationEntryArray = ((Annotations)attribute).getAnnotationEntries()) {
                arrayList.add(annotationEntry);
            }
        }
        return (AnnotationEntry[])arrayList.toArray();
    }

    public static AnnotationEntry read(DataInput dataInput, ConstantPool constantPool, boolean bl) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(dataInput.readUnsignedShort(), constantPool, bl);
        int n = dataInput.readUnsignedShort();
        annotationEntry.elementValuePairs = new ArrayList<ElementValuePair>();
        for (int i = 0; i < n; ++i) {
            annotationEntry.elementValuePairs.add(new ElementValuePair(dataInput.readUnsignedShort(), ElementValue.readElementValue(dataInput, constantPool), constantPool));
        }
        return annotationEntry;
    }

    public AnnotationEntry(int n, ConstantPool constantPool, boolean bl) {
        this.typeIndex = n;
        this.constantPool = constantPool;
        this.isRuntimeVisible = bl;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAnnotationEntry(this);
    }

    public void addElementNameValuePair(ElementValuePair elementValuePair) {
        this.elementValuePairs.add(elementValuePair);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.typeIndex);
        dataOutputStream.writeShort(this.elementValuePairs.size());
        for (ElementValuePair elementValuePair : this.elementValuePairs) {
            elementValuePair.dump(dataOutputStream);
        }
    }

    public String getAnnotationType() {
        return this.constantPool.getConstantUtf8(this.typeIndex).getBytes();
    }

    public int getAnnotationTypeIndex() {
        return this.typeIndex;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.elementValuePairs.toArray(ElementValuePair.EMPTY_ARRAY);
    }

    public final int getNumElementValuePairs() {
        return this.elementValuePairs.size();
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@");
        stringBuilder.append(this.getAnnotationType());
        ElementValuePair[] elementValuePairArray = this.getElementValuePairs();
        if (elementValuePairArray.length > 0) {
            stringBuilder.append("(");
            for (ElementValuePair elementValuePair : elementValuePairArray) {
                stringBuilder.append(elementValuePair.toShortString());
                stringBuilder.append(", ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toShortString();
    }
}

