/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ECDHKeyExchange;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.JsseJce;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.Utilities;
import sun.security.ssl.X509Authentication;

final class ECDHClientKeyExchange {
    static final SSLConsumer ecdhHandshakeConsumer = new ECDHClientKeyExchangeConsumer();
    static final HandshakeProducer ecdhHandshakeProducer = new ECDHClientKeyExchangeProducer();
    static final SSLConsumer ecdheHandshakeConsumer = new ECDHEClientKeyExchangeConsumer();
    static final HandshakeProducer ecdheHandshakeProducer = new ECDHEClientKeyExchangeProducer();

    ECDHClientKeyExchange() {
    }

    private static final class ECDHClientKeyExchangeConsumer
    implements SSLConsumer {
        private ECDHClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            X509Authentication.X509Possession x509Possession = null;
            for (Object object42 : serverHandshakeContext.handshakePossessions) {
                if (!(object42 instanceof X509Authentication.X509Possession)) continue;
                x509Possession = (X509Authentication.X509Possession)object42;
                break;
            }
            if (x509Possession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No expected EC server cert for ECDH client key exchange");
            }
            ECParameterSpec eCParameterSpec = x509Possession.getECParameterSpec();
            if (eCParameterSpec == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not EC server cert for ECDH client key exchange");
            }
            object42 = SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec);
            if (object42 == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDH client key exchange");
            }
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            ECDHClientKeyExchangeMessage eCDHClientKeyExchangeMessage = new ECDHClientKeyExchangeMessage((HandshakeContext)serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECDH ClientKeyExchange handshake message", eCDHClientKeyExchangeMessage);
            }
            try {
                object3 = JsseJce.decodePoint(eCDHClientKeyExchangeMessage.encodedPoint, eCParameterSpec.getCurve());
                object2 = new ECPublicKeySpec((ECPoint)object3, eCParameterSpec);
                object = JsseJce.getKeyFactory("EC");
                ECPublicKey eCPublicKey = (ECPublicKey)((KeyFactory)object).generatePublic((KeySpec)object2);
                if (!serverHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), eCPublicKey)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
                serverHandshakeContext.handshakeCredentials.add(new ECDHKeyExchange.ECDHECredentials(eCPublicKey, (SupportedGroupsExtension.NamedGroup)((Object)object42)));
            }
            catch (IOException | GeneralSecurityException exception) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(exception);
            }
            object3 = sSLKeyExchange.createKeyDerivation(serverHandshakeContext);
            object2 = object3.deriveKey("MasterSecret", null);
            serverHandshakeContext.handshakeSession.setMasterSecret((SecretKey)object2);
            object = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (object == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            serverHandshakeContext.handshakeKeyDerivation = ((SSLTrafficKeyDerivation)object).createKeyDerivation(serverHandshakeContext, (SecretKey)object2);
        }
    }

    private static final class ECDHClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private final byte[] encodedPoint;

        ECDHClientKeyExchangeMessage(HandshakeContext handshakeContext, ECPublicKey eCPublicKey) {
            super(handshakeContext);
            ECPoint eCPoint = eCPublicKey.getW();
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            this.encodedPoint = JsseJce.encodePoint(eCPoint, eCParameterSpec.getCurve());
        }

        ECDHClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            this.encodedPoint = byteBuffer.remaining() != 0 ? Record.getBytes8(byteBuffer) : new byte[0];
        }

        static void checkConstraints(AlgorithmConstraints algorithmConstraints, ECPublicKey eCPublicKey, byte[] byArray) throws SSLHandshakeException {
            try {
                ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
                ECPoint eCPoint = JsseJce.decodePoint(byArray, eCParameterSpec.getCurve());
                ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
                KeyFactory keyFactory = JsseJce.getKeyFactory("EC");
                ECPublicKey eCPublicKey2 = (ECPublicKey)keyFactory.generatePublic(eCPublicKeySpec);
                if (!algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), eCPublicKey2)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
            }
            catch (IOException | GeneralSecurityException exception) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(exception);
            }
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                return 0;
            }
            return 1 + this.encodedPoint.length;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            if (this.encodedPoint != null && this.encodedPoint.length != 0) {
                handshakeOutStream.putBytes8(this.encodedPoint);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"ECDH ClientKeyExchange\": '{'\n  \"ecdh public\": '{'\n{0}\n  '}',\n'}'", Locale.ENGLISH);
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                Object[] objectArray = new Object[]{"    <implicit>"};
                return messageFormat.format(objectArray);
            }
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.encodedPoint), "    ")};
            return messageFormat.format(objectArray);
        }
    }

    private static final class ECDHClientKeyExchangeProducer
    implements HandshakeProducer {
        private ECDHClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object2;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            X509Authentication.X509Credentials x509Credentials = null;
            for (Object object2 : clientHandshakeContext.handshakeCredentials) {
                if (!(object2 instanceof X509Authentication.X509Credentials)) continue;
                x509Credentials = (X509Authentication.X509Credentials)object2;
                break;
            }
            if (x509Credentials == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No server certificate for ECDH client key exchange");
            }
            PublicKey publicKey = x509Credentials.popPublicKey;
            if (!publicKey.getAlgorithm().equals("EC")) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Not EC server certificate for ECDH client key exchange");
            }
            object2 = ((ECPublicKey)publicKey).getParams();
            SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf((ECParameterSpec)object2);
            if (namedGroup == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDH client key exchange");
            }
            ECDHKeyExchange.ECDHEPossession eCDHEPossession = new ECDHKeyExchange.ECDHEPossession(namedGroup, clientHandshakeContext.sslContext.getSecureRandom());
            clientHandshakeContext.handshakePossessions.add(eCDHEPossession);
            ECDHClientKeyExchangeMessage eCDHClientKeyExchangeMessage = new ECDHClientKeyExchangeMessage((HandshakeContext)clientHandshakeContext, eCDHEPossession.publicKey);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECDH ClientKeyExchange handshake message", eCDHClientKeyExchangeMessage);
            }
            eCDHClientKeyExchangeMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
            return null;
        }
    }

    private static final class ECDHEClientKeyExchangeConsumer
    implements SSLConsumer {
        private ECDHEClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            ECDHKeyExchange.ECDHEPossession eCDHEPossession = null;
            for (Object object42 : serverHandshakeContext.handshakePossessions) {
                if (!(object42 instanceof ECDHKeyExchange.ECDHEPossession)) continue;
                eCDHEPossession = (ECDHKeyExchange.ECDHEPossession)object42;
                break;
            }
            if (eCDHEPossession == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No expected ECDHE possessions for client key exchange");
            }
            ECParameterSpec eCParameterSpec = eCDHEPossession.publicKey.getParams();
            object42 = SupportedGroupsExtension.NamedGroup.valueOf(eCParameterSpec);
            if (object42 == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for ECDHE client key exchange");
            }
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            ECDHClientKeyExchangeMessage eCDHClientKeyExchangeMessage = new ECDHClientKeyExchangeMessage((HandshakeContext)serverHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ECDHE ClientKeyExchange handshake message", eCDHClientKeyExchangeMessage);
            }
            try {
                object3 = JsseJce.decodePoint(eCDHClientKeyExchangeMessage.encodedPoint, eCParameterSpec.getCurve());
                object2 = new ECPublicKeySpec((ECPoint)object3, eCParameterSpec);
                object = JsseJce.getKeyFactory("EC");
                ECPublicKey eCPublicKey = (ECPublicKey)((KeyFactory)object).generatePublic((KeySpec)object2);
                if (!serverHandshakeContext.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), eCPublicKey)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
                serverHandshakeContext.handshakeCredentials.add(new ECDHKeyExchange.ECDHECredentials(eCPublicKey, (SupportedGroupsExtension.NamedGroup)((Object)object42)));
            }
            catch (IOException | GeneralSecurityException exception) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(exception);
            }
            object3 = sSLKeyExchange.createKeyDerivation(serverHandshakeContext);
            object2 = object3.deriveKey("MasterSecret", null);
            serverHandshakeContext.handshakeSession.setMasterSecret((SecretKey)object2);
            object = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (object == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            serverHandshakeContext.handshakeKeyDerivation = ((SSLTrafficKeyDerivation)object).createKeyDerivation(serverHandshakeContext, (SecretKey)object2);
        }
    }

    private static final class ECDHEClientKeyExchangeProducer
    implements HandshakeProducer {
        private ECDHEClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object2;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            ECDHKeyExchange.ECDHECredentials eCDHECredentials = null;
            for (Object object2 : clientHandshakeContext.handshakeCredentials) {
                if (!(object2 instanceof ECDHKeyExchange.ECDHECredentials)) continue;
                eCDHECredentials = (ECDHKeyExchange.ECDHECredentials)object2;
                break;
            }
            if (eCDHECredentials == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "No ECDHE credentials negotiated for client key exchange");
            }
            ECDHKeyExchange.ECDHEPossession eCDHEPossession = new ECDHKeyExchange.ECDHEPossession(eCDHECredentials, clientHandshakeContext.sslContext.getSecureRandom());
            clientHandshakeContext.handshakePossessions.add(eCDHEPossession);
            object2 = new ECDHClientKeyExchangeMessage((HandshakeContext)clientHandshakeContext, eCDHEPossession.publicKey);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ECDHE ClientKeyExchange handshake message", object2);
            }
            ((SSLHandshake.HandshakeMessage)object2).write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
            return null;
        }
    }
}

