/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Platform;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.resources.ResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import javax.jnlp.FileContents;
import javax.jnlp.JNLPRandomAccessFile;

public final class JNLPRandomAccessFileNSBImpl
implements JNLPRandomAccessFile {
    private FileContents _contents = null;
    private final String _file;
    private String _message = null;
    private NativeSandboxBroker broker = null;

    JNLPRandomAccessFileNSBImpl(File file, String string, FileContents fileContents) throws IOException {
        this._contents = fileContents;
        if (!string.equals("rw")) {
            throw new IllegalArgumentException("Only \"rw\" mode is supported");
        }
        if (this._contents == null) {
            throw new IllegalArgumentException("FileContents can not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("File can not be null");
        }
        this._file = file.getAbsolutePath();
        this.broker = Platform.get().getNativeSandboxBroker();
        if (this.broker == null) {
            throw new IllegalArgumentException("Broker can not be null");
        }
        if (this._message == null) {
            this._message = ResourceManager.getString((String)"api.persistence.filesizemessage");
        }
    }

    public void close() throws IOException {
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(0, this._file);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
    }

    public long length() throws IOException {
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(2, this._file);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
        return rAF2.getLongValue();
    }

    public long getFilePointer() throws IOException {
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(1, this._file);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
        return rAF2.getLongValue();
    }

    private DataInputStream getDIS(int n) throws EOFException, IOException {
        if (n <= 0) {
            throw new IOException("b.length <= 0");
        }
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(1, this._file);
        rAF.setLongValue((long)n);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getEOFException() != null) {
            throw new EOFException(rAF2.getEOFException());
        }
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(rAF2.getData());
        return new DataInputStream(byteArrayInputStream);
    }

    private RAFDataOutputStream getDOS() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        return new RAFDataOutputStream(byteArrayOutputStream);
    }

    private void sendDOS(RAFDataOutputStream rAFDataOutputStream) throws IOException {
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(9, this._file);
        rAF.setData(rAFDataOutputStream.toByteArray());
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
    }

    public int read() throws IOException {
        return this.getDIS(4).read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.getDIS(n2).read(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.getDIS(byArray.length).read(byArray);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.getDIS(byArray.length).readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.getDIS(byArray.length).readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(8, this._file);
        rAF.setLongValue((long)n);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
        return (int)rAF2.getLongValue();
    }

    public boolean readBoolean() throws IOException {
        return this.getDIS(1).readBoolean();
    }

    public byte readByte() throws IOException {
        return this.getDIS(1).readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.getDIS(1).readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.getDIS(2).readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.getDIS(2).readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.getDIS(1).readChar();
    }

    public int readInt() throws IOException {
        return this.getDIS(4).readInt();
    }

    public long readLong() throws IOException {
        return this.getDIS(8).readLong();
    }

    public float readFloat() throws IOException {
        return this.getDIS(4).readFloat();
    }

    public double readDouble() throws IOException {
        return this.getDIS(8).readDouble();
    }

    public String readLine() throws IOException {
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(4, this._file);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getEOFException() != null) {
            throw new EOFException(rAF2.getEOFException());
        }
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
        return rAF2.getString();
    }

    public String readUTF() throws IOException {
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(5, this._file);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getEOFException() != null) {
            throw new EOFException(rAF2.getEOFException());
        }
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
        return rAF2.getString();
    }

    public void seek(long l) throws IOException {
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(6, this._file);
        rAF.setLongValue(l);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
    }

    public void setLength(long l) throws IOException {
        if (l > this._contents.getMaxLength()) {
            throw new IOException(this._message);
        }
        NativeSandboxBroker.RAF rAF = new NativeSandboxBroker.RAF(7, this._file);
        rAF.setLongValue(l);
        NativeSandboxBroker.RAF rAF2 = this.broker.sendRAF(rAF);
        if (rAF2.getIOException() != null) {
            throw new IOException(rAF2.getIOException());
        }
    }

    public void write(int n) throws IOException {
        this.checkWrite(1);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.write(n);
        this.sendDOS(rAFDataOutputStream);
    }

    public void write(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.checkWrite(byArray.length);
        }
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.write(byArray);
        this.sendDOS(rAFDataOutputStream);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkWrite(n2);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.write(byArray, n, n2);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.checkWrite(1);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeBoolean(bl);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeByte(int n) throws IOException {
        this.checkWrite(1);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeByte(n);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeShort(int n) throws IOException {
        this.checkWrite(2);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeShort(n);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeChar(int n) throws IOException {
        this.checkWrite(2);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeChar(n);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeInt(int n) throws IOException {
        this.checkWrite(4);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeInt(n);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeLong(long l) throws IOException {
        this.checkWrite(8);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeLong(l);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeFloat(float f) throws IOException {
        this.checkWrite(4);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeFloat(f);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeDouble(double d) throws IOException {
        this.checkWrite(8);
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeDouble(d);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeBytes(String string) throws IOException {
        if (string != null) {
            this.checkWrite(string.length());
        }
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeBytes(string);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeChars(String string) throws IOException {
        if (string != null) {
            this.checkWrite(string.length() * 2);
        }
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeChars(string);
        this.sendDOS(rAFDataOutputStream);
    }

    public void writeUTF(String string) throws IOException {
        if (string != null) {
            this.checkWrite(this.getUTFLen(string));
        }
        RAFDataOutputStream rAFDataOutputStream = this.getDOS();
        rAFDataOutputStream.writeUTF(string);
        this.sendDOS(rAFDataOutputStream);
    }

    private int getUTFLen(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }

    private void checkWrite(int n) throws IOException {
        if (n < 0 || this._contents.getMaxLength() - this.getFilePointer() < (long)n) {
            throw new IOException(this._message);
        }
    }

    private class RAFDataOutputStream
    extends DataOutputStream {
        private final ByteArrayOutputStream baos;

        public RAFDataOutputStream(ByteArrayOutputStream byteArrayOutputStream) {
            super(byteArrayOutputStream);
            this.baos = byteArrayOutputStream;
        }

        public byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }
}

