package com.qk.unity;

import android.text.TextUtils;
import android.util.Log;
import com.alibaba.netspeed.network.DetectConfig;
import com.alibaba.netspeed.network.Diagnosis;
import com.alibaba.netspeed.network.DnsConfig;
import com.alibaba.netspeed.network.HttpConfig;
import com.alibaba.netspeed.network.MtrConfig;
import com.alibaba.netspeed.network.PingConfig;
import com.alibaba.netspeed.network.TcpPingConfig;

public class NetworkDiagnosis {

    public static final String TAG = "GSNetworkDiagnosis";

    public static void init(String secretKey, String deviceId, String siteId, String extension) {
        Log.d(TAG, "init: secretKey=" + secretKey + ", deviceId=" + deviceId + ", siteId=" + siteId
            + ", extension=" + extension);
        Diagnosis.init(secretKey, TextUtils.isEmpty(deviceId) ? null : deviceId,
            TextUtils.isEmpty(siteId) ? null : siteId, SDKUtils.jsonStr2StringMap(extension));
    }
    public static void startHttpPing(String url) {
        Log.d(TAG, "startHttpPing: " + url);
        // http
        HttpConfig httpConfig = new HttpConfig(null, url, null, null);
        Diagnosis.startHttpPing((DetectConfig)httpConfig);

    }

    public static void startPing(String url, int maxTimes, int timeout) {
        Log.d(TAG, "startPing: " + url);
// ping， 1000ms超时，ping 10次，目标地址：www.aliyun.com
        PingConfig pingConfig = new PingConfig(null, url, maxTimes, timeout, null, null);
        Diagnosis.startPing((DetectConfig)pingConfig);


    }

    public static void startTcpPing(String url, int port, int maxTimes, int timeout) {
        // tcpping， 1000ms超时，ping 10次，目标地址：www.aliyun.com:443
        Log.d(TAG, "startTcpPing: " + url + ":" + port);
        TcpPingConfig tcpPingConfig = new TcpPingConfig(null, url, port, maxTimes, timeout, null,
            null);
        Diagnosis.startTcpPing((DetectConfig)tcpPingConfig);

    }

    public static void startMtr(String url, int maxTtl, int maxPaths, int maxTimes, int timeout) {
        Log.d(TAG, "startMtr: " + url);
// mtr，目标www.aliyun.com，路径最长长度30，探测1条路径，每个节点测试10次，超时时间1000ms
        MtrConfig mtrConfig = new MtrConfig(null, url, maxTtl, maxPaths, maxTimes, timeout, null, null);
        Diagnosis.startMtr((DetectConfig)mtrConfig);

    }

    public static void startDns(String url, String type, int timeout) {
        Log.d(TAG, "startDns: " + url);
// dns， nameServer可以传null，默认会用localdns，请求A记录，1000ms超时
        DnsConfig dnsConfig = new DnsConfig(null, null, url, type, timeout, null, null);
        Diagnosis.startDns((DetectConfig)dnsConfig);
    }

}
