//
//

#import <Foundation/Foundation.h>

@interface REDeOrderInfo : NSObject
@property (copy,nonatomic) NSString *productId;     //必填 开发者后台的商品ID，productID
@property (copy,nonatomic) NSString *product_order_no;  //游戏产品订单号必传
@property (copy,nonatomic) NSString *subject;       //虚拟商品名称 必填
@property (copy,nonatomic) NSString *desc;          //商品描述 可选
@property (copy,nonatomic) NSString *price;           //商品单价 可选
@property (assign,nonatomic) unsigned int quantity;   //购买数量 可选 默认1
@property (copy,nonatomic) NSString *total;       //商品总价 必填，影响购买统计和后台回调
@property (copy,nonatomic) NSString *callback_url;      //回调通知地址 string[200] 可选，（可后台配置，后台配置了回调地址就以后台配置的为准）
@property (copy,nonatomic) NSString *extras_params;     //扩展参数 string[500] 可选，透传字段，注意：扩展字段请勿传特殊符号，如果无法避免建议先进行base64编码后再传，用于查找商品信息返回商品属性时返回货币符号
@property (copy,nonatomic) NSString * displayPrice;/** 商品显示价格 用于查找商品信息返回商品属性*/
@property (copy,nonatomic) NSString * currencySymbol;/** 商品货币符号 用于查找商品信息返回商品属性*/
@property (copy,nonatomic) NSString * currencyCode;/** 商品货币代码 下单可选如有值则上报统计时用此值，查找商品信息返回商品属性*/
/** 是否家庭共享 可选字段，主要用于查找商品信息返回商品属性 */
@property (assign,nonatomic) BOOL isFamilyShareable API_AVAILABLE(ios(14.0));
/** 商品类型 1消耗品2非消耗类商品3自动续期订阅4非续期订阅 可选字段，主要用于storekit2查找商品信息返回商品属性 */
@property (assign,nonatomic) NSInteger productType API_AVAILABLE(ios(15.0));
/** 订阅品是否有资格享受优惠 可选字段，主要用于storekit2查找商品信息返回商品属性 */
@property (assign,nonatomic) BOOL isEligibleForIntroOffer API_AVAILABLE(ios(15.0));

+ (instancetype)infoWithProductId:(NSString *)productId orderNo:(NSString *)orderNo subject:(NSString *)subject total:(NSString *)totalPrice;
- (void)setInfoWithParameter:(REDeOrderInfo *)param;

@end
