# 简单的测试打包脚本
Write-Host "测试electron-packager..." -ForegroundColor Cyan

# 确保在脚本所在目录运行
Set-Location $PSScriptRoot

# 清理之前的构建
if (Test-Path "dist") {
    Remove-Item -Path "dist" -Recurse -Force
    Write-Host "已清理dist目录" -ForegroundColor Yellow
}

# 运行打包
Write-Host "开始打包..." -ForegroundColor Yellow
try {
    npm run pack
    Write-Host "npm run pack 完成" -ForegroundColor Green
} catch {
    Write-Host "npm run pack 失败: $($_.Exception.Message)" -ForegroundColor Red
}

# 检查结果
if (Test-Path "dist") {
    Write-Host "dist目录已生成，内容如下:" -ForegroundColor Green
    Get-ChildItem -Path "dist" -Recurse | Select-Object FullName | ForEach-Object { Write-Host "  $($_.FullName)" }
} else {
    Write-Host "dist目录未生成，打包失败" -ForegroundColor Red
    Write-Host "尝试直接运行electron-packager..." -ForegroundColor Yellow
    
    try {
        npx electron-packager . boss-timer --platform=win32 --arch=x64 --out=dist --overwrite
        Write-Host "直接运行electron-packager完成" -ForegroundColor Green
    } catch {
        Write-Host "直接运行electron-packager也失败: $($_.Exception.Message)" -ForegroundColor Red
    }
}

Read-Host "按回车键继续..."