# Boss时间计时器

一个基于Electron开发的Boss时间计时器应用，帮助游戏玩家追踪Boss重生时间。

## 功能特性

- 🎮 支持MVP和Mini Boss两种类型
- ⏰ 精确的倒计时功能
- 🔔 Windows系统通知提醒
- 🎨 现代化的用户界面
- ⌨️ 键盘快捷键支持（空格键开始/暂停）
- 📱 响应式设计

## 安装依赖

确保您的系统已安装Node.js，然后运行：

```bash
npm install
```

## 运行应用

```bash
npm start
```

## 使用方法

1. **选择Boss**: 在左侧的MVP或Mini列表中点击选择要计时的Boss
2. **设置时间**: 在计时器区域设置分钟和秒数
3. **开始计时**: 点击"开始"按钮或按空格键开始倒计时
4. **暂停/继续**: 计时过程中可以暂停和继续
5. **重置**: 点击"重置"按钮重新设置时间

## 配置文件

应用会读取 `config.json` 文件来配置：

- 窗口尺寸 (Screen.Width, Screen.Height)
- MVP Boss列表
- Mini Boss列表

### 配置示例

```json
{
    "Screen":{
        "Width":1280,
        "Height":800
    },
    "MVP":[
        {"boss":"皮皮"},
        {"boss":"蜂后"},
        {"boss":"乌贼"}
    ],
    "Mini":[
        {"boss":"龙蝇"},
        {"boss":"兔子"},
        {"boss":"波王"}
    ]
}
```

## 系统要求

- Windows 10 或更高版本
- Node.js 16.0 或更高版本
- 足够的内存运行Electron应用

## 键盘快捷键

- `空格键`: 开始/暂停计时器

## 开发模式

如果您想要开发或调试应用，可以启用开发者工具：

在 `main.js` 中取消注释这一行：
```javascript
// mainWindow.webContents.openDevTools();
```

## 许可证

MIT License 