# CLAUDE.md

This file provides guidance to Claude Code (claude.ai/code) when working with code in this repository.
本文件为 Claude Code (claude.ai/code) 在此代码库中工作时提供指导。

## 项目概述 (Project Overview)

这是一个基于 Electron 构建的 Boss 计时器应用程序，帮助游戏玩家追踪 Boss 重生时间。该应用提供 MVP 和 Mini Boss 的倒计时功能，具有通知功能和灵活的时区支持。

## 开发命令 (Development Commands)

### 基本命令 (Basic Commands)
```bash
# 安装依赖
npm install

# 在开发模式下启动应用
npm start

# 使用开发标志启动
npm run dev

# 为不同平台构建
npm run build          # 为当前平台构建
npm run build:win      # 为 Windows 构建
npm run build:mac      # 为 macOS 构建
npm run build:linux    # 为 Linux 构建

# 打包应用
npm run pack           # 使用 electron-packager 打包
npm run dist           # 使用 electron-builder 创建分发包
```

### 批处理脚本 (Batch Scripts)
- `build-and-pack.bat` - Windows 批处理构建和打包脚本
- `build-and-pack.ps1` - PowerShell 构建和打包脚本

## 架构 (Architecture)

### 主进程 (Main Process - main.js)
- 处理 Electron 主进程功能
- 管理窗口创建和生命周期
- 实现 IPC 处理程序：
  - 配置加载 (`get-config`)
  - Boss 信息获取 (`get-boss-info`)
  - 文件读取 (`read-file-content`)
  - 系统通知 (`send-notification`)
  - 窗口管理 (`toggle-always-on-top`)
- 监视 `sBossInfo.json` 文件变化
- 创建带有窗口控件的应用菜单

### 渲染进程 (Renderer Process - renderer.js)
- 包含管理所有应用逻辑的主要 `BossTimer` 类
- 处理 Electron 和浏览器环境
- 主要功能：
  - 实时 Boss 倒计时追踪
  - 手动计时器创建和管理
  - 时区支持与实时时钟
  - 基于文件的 Boss 数据加载
  - 通知系统
  - 收藏 Boss 管理
  - 调试模式测试

### 配置文件 (Configuration Files)
- `config.json` - 主配置文件，定义：
  - 屏幕尺寸
  - Boss 定义（ID、名称、类型和刷新时间）
  - MVP Boss 有 3 小时 (10800秒) 刷新时间
  - Mini Boss 有 2 小时 (7200秒) 刷新时间
- `sBossInfo.json` - 运行时 Boss 状态数据（不在仓库中）

### 文件结构 (File Structure)
```
/
├── main.js           # Electron 主进程
├── renderer.js       # 应用逻辑和 UI 处理
├── index.html        # 主应用 UI
├── styles.css        # 应用样式
├── config.json       # Boss 和屏幕配置
├── package.json      # Node.js 依赖和脚本
├── assets/           # 应用资源（图标）
├── dist/             # 构建输出目录
└── node_modules/     # 依赖包
```

## 主要功能 (Key Features)

### Boss 管理 (Boss Management)
- 支持 MVP 和 Mini Boss 类型
- 每个 Boss 可配置刷新时间
- 实时倒计时与时区支持
- 收藏 Boss 系统用于优先级排序
- 手动计时器创建用于自定义倒计时

### 通知系统 (Notification System)
- 跨平台通知（Electron 系统通知、浏览器 Web API）
- Boss 即将刷新时提醒（< 1 分钟）
- 计时器完成时的音频通知
- 防止每个 Boss 重复通知

### 文件监视 (File Watching)
- 监视 `sBossInfo.json` 的外部更新
- 支持自定义 Boss 数据文件
- Electron 模式下每 5 秒自动刷新
- 浏览器模式下手动文件选择

### 调试模式 (Debug Mode)
- 创建带有倒计时的测试 Boss 数据
- 启用通知测试
- 绕过文件监视进行受控测试

## 开发注意事项 (Development Notes)

### 双环境支持 (Dual Environment Support)
应用在 Electron 和浏览器环境中运行：
- 使用 `isElectron` 标志检测环境
- Electron：完整文件系统访问、系统通知、IPC
- 浏览器：限制为选定文件、Web Notification API

### 时区处理 (Time Zone Handling)
- 支持自定义时区偏移（-12 到 +14）
- 显示本地时间和北京时间（UTC+8）
- 在 localStorage 中持久化时区设置

### 计时器管理 (Timer Management)
- 活动计时器存储在带有唯一 ID 的 `Map` 中
- 支持暂停/恢复功能
- 自动清理已完成的计时器
- 准备时间缓冲区（手动计时器添加 60 秒）

### 性能优化 (Performance Optimizations)
- 使用元素重用的高效 DOM 更新
- 使用变化检测的最小重新渲染
- 更新期间保持滚动位置
- 每秒批量计时器更新

## 测试 (Testing)

### 调试模式测试 (Debug Mode Testing)
1. 启用调试模式复选框
2. 创建带有交错倒计时的测试 Boss 数据
3. 使用"测试通知"按钮验证通知系统
4. 调试模式绕过文件监视进行受控测试

### 手动测试 (Manual Testing)
- 测试 MVP 和 Mini Boss 选择
- 验证时区更改更新所有显示
- 测试两种环境下的文件选择
- 验证通知权限和功能