/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis.util;

import com.android.tools.smali.dexlib2.analysis.TypeProto;
import com.android.tools.smali.dexlib2.analysis.UnresolvedClassException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TypeProtoUtils {
    public static Iterable<TypeProto> getSuperclassChain(final TypeProto typeProto) {
        return new Iterable<TypeProto>(){

            @Override
            public Iterator<TypeProto> iterator() {
                return new Iterator<TypeProto>(){
                    private TypeProto type;
                    {
                        this.type = TypeProtoUtils.getSuperclassAsTypeProto(typeProto);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.type != null;
                    }

                    @Override
                    public TypeProto next() {
                        TypeProto type = this.type;
                        if (type == null) {
                            throw new NoSuchElementException();
                        }
                        this.type = TypeProtoUtils.getSuperclassAsTypeProto(type);
                        return type;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static TypeProto getSuperclassAsTypeProto(TypeProto type) {
        try {
            String next = type.getSuperclass();
            if (next != null) {
                return type.getClassPath().getClass(next);
            }
            return null;
        }
        catch (UnresolvedClassException ex) {
            return type.getClassPath().getUnknownClass();
        }
    }

    public static boolean extendsFrom(TypeProto candidate, String possibleSuper) {
        if (candidate.getType().equals(possibleSuper)) {
            return true;
        }
        for (TypeProto superProto : TypeProtoUtils.getSuperclassChain(candidate)) {
            if (!superProto.getType().equals(possibleSuper)) continue;
            return true;
        }
        return false;
    }
}

