/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.net.URI;
import java.net.URISyntaxException;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsFileSystem;
import sun.nio.fs.WindowsPath;

class WindowsUriSupport {
    private static final String IPV6_LITERAL_SUFFIX = ".ipv6-literal.net";

    private WindowsUriSupport() {
    }

    private static URI toUri(String string, boolean bl, boolean bl2) {
        String string2;
        String string3;
        if (bl) {
            int n = string.indexOf(92, 2);
            string3 = string.substring(2, n);
            string2 = string.substring(n).replace('\\', '/');
            if (string3.endsWith(IPV6_LITERAL_SUFFIX)) {
                string3 = string3.substring(0, string3.length() - IPV6_LITERAL_SUFFIX.length()).replace('-', ':').replace('s', '%');
            }
        } else {
            string3 = "";
            string2 = "/" + string.replace('\\', '/');
        }
        if (bl2) {
            string2 = string2 + "/";
        }
        try {
            return new URI("file", string3, string2, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (!bl) {
                throw new AssertionError((Object)uRISyntaxException);
            }
            string2 = "//" + string.replace('\\', '/');
            if (bl2) {
                string2 = string2 + "/";
            }
            try {
                return new URI("file", null, string2, null);
            }
            catch (URISyntaxException uRISyntaxException2) {
                throw new AssertionError((Object)uRISyntaxException2);
            }
        }
    }

    static URI toUri(WindowsPath windowsPath) {
        windowsPath = windowsPath.toAbsolutePath();
        String string = windowsPath.toString();
        boolean bl = false;
        if (!string.endsWith("\\")) {
            try {
                windowsPath.checkRead();
                bl = WindowsFileAttributes.get(windowsPath, true).isDirectory();
            }
            catch (SecurityException | WindowsException exception) {
                // empty catch block
            }
        }
        return WindowsUriSupport.toUri(string, windowsPath.isUnc(), bl);
    }

    static WindowsPath fromUri(WindowsFileSystem windowsFileSystem, URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String string2 = uRI.getPath();
        if (string2.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        String string3 = uRI.getAuthority();
        if (string3 != null && !string3.equals("")) {
            String string4 = uRI.getHost();
            if (string4 == null) {
                throw new IllegalArgumentException("URI authority component has undefined host");
            }
            if (uRI.getUserInfo() != null) {
                throw new IllegalArgumentException("URI authority component has user-info");
            }
            if (uRI.getPort() != -1) {
                throw new IllegalArgumentException("URI authority component has port number");
            }
            if (string4.startsWith("[")) {
                string4 = string4.substring(1, string4.length() - 1).replace(':', '-').replace('%', 's');
                string4 = string4 + IPV6_LITERAL_SUFFIX;
            }
            string2 = "\\\\" + string4 + string2;
        } else if (string2.length() > 2 && string2.charAt(2) == ':') {
            string2 = string2.substring(1);
        }
        return WindowsPath.parse(windowsFileSystem, string2);
    }
}

