/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import com.sun.imageio.plugins.common.StandardMetadataFormat;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadataFormat;

public abstract class IIOMetadataFormatImpl
implements IIOMetadataFormat {
    public static final String standardMetadataFormatName = "javax_imageio_1.0";
    private static IIOMetadataFormat standardFormat = null;
    private String resourceBaseName = this.getClass().getName() + "Resources";
    private String rootName;
    private HashMap elementMap = new HashMap();

    public IIOMetadataFormatImpl(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("rootName == null!");
        }
        if (n < 0 || n > 5 || n == 5) {
            throw new IllegalArgumentException("Invalid value for childPolicy!");
        }
        this.rootName = string;
        Element element = new Element();
        element.elementName = string;
        element.childPolicy = n;
        this.elementMap.put(string, element);
    }

    public IIOMetadataFormatImpl(String string, int n, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("rootName == null!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("minChildren < 0!");
        }
        if (n > n2) {
            throw new IllegalArgumentException("minChildren > maxChildren!");
        }
        Element element = new Element();
        element.elementName = string;
        element.childPolicy = 5;
        element.minChildren = n;
        element.maxChildren = n2;
        this.rootName = string;
        this.elementMap.put(string, element);
    }

    protected void setResourceBaseName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("resourceBaseName == null!");
        }
        this.resourceBaseName = string;
    }

    protected String getResourceBaseName() {
        return this.resourceBaseName;
    }

    private Element getElement(String string, boolean bl) {
        if (bl && string == null) {
            throw new IllegalArgumentException("element name is null!");
        }
        Element element = (Element)this.elementMap.get(string);
        if (bl && element == null) {
            throw new IllegalArgumentException("No such element: " + string);
        }
        return element;
    }

    private Element getElement(String string) {
        return this.getElement(string, true);
    }

    private Attribute getAttribute(String string, String string2) {
        Element element = this.getElement(string);
        Attribute attribute = (Attribute)element.attrMap.get(string2);
        if (attribute == null) {
            throw new IllegalArgumentException("No such attribute \"" + string2 + "\"!");
        }
        return attribute;
    }

    protected void addElement(String string, String string2, int n) {
        Element element = this.getElement(string2);
        if (n < 0 || n > 5 || n == 5) {
            throw new IllegalArgumentException("Invalid value for childPolicy!");
        }
        Element element2 = new Element();
        element2.elementName = string;
        element2.childPolicy = n;
        element.childList.add(string);
        element2.parentList.add(string2);
        this.elementMap.put(string, element2);
    }

    protected void addElement(String string, String string2, int n, int n2) {
        Element element = this.getElement(string2);
        if (n < 0) {
            throw new IllegalArgumentException("minChildren < 0!");
        }
        if (n > n2) {
            throw new IllegalArgumentException("minChildren > maxChildren!");
        }
        Element element2 = new Element();
        element2.elementName = string;
        element2.childPolicy = 5;
        element2.minChildren = n;
        element2.maxChildren = n2;
        element.childList.add(string);
        element2.parentList.add(string2);
        this.elementMap.put(string, element2);
    }

    protected void addChildElement(String string, String string2) {
        Element element = this.getElement(string2);
        Element element2 = this.getElement(string);
        element.childList.add(string);
        element2.parentList.add(string2);
    }

    protected void removeElement(String string) {
        Element element = this.getElement(string, false);
        if (element != null) {
            for (String string2 : element.parentList) {
                Element element2 = this.getElement(string2, false);
                if (element2 == null) continue;
                element2.childList.remove(string);
            }
            this.elementMap.remove(string);
        }
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        Attribute attribute = new Attribute();
        attribute.attrName = string2;
        attribute.valueType = 1;
        attribute.dataType = n;
        attribute.required = bl;
        attribute.defaultValue = string3;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3, List<String> list) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        if (list == null) {
            throw new IllegalArgumentException("enumeratedValues == null!");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("enumeratedValues is empty!");
        }
        for (String object2 : list) {
            if (object2 == null) {
                throw new IllegalArgumentException("enumeratedValues contains a null!");
            }
            if (object2 instanceof String) continue;
            throw new IllegalArgumentException("enumeratedValues contains a non-String value!");
        }
        Attribute attribute = new Attribute();
        attribute.attrName = string2;
        attribute.valueType = 16;
        attribute.dataType = n;
        attribute.required = bl;
        attribute.defaultValue = string3;
        attribute.enumeratedValues = list;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, String string3, String string4, String string5, boolean bl2, boolean bl3) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        Attribute attribute = new Attribute();
        attribute.attrName = string2;
        attribute.valueType = 2;
        if (bl2) {
            attribute.valueType |= 4;
        }
        if (bl3) {
            attribute.valueType |= 8;
        }
        attribute.dataType = n;
        attribute.required = bl;
        attribute.defaultValue = string3;
        attribute.minValue = string4;
        attribute.maxValue = string5;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    protected void addAttribute(String string, String string2, int n, boolean bl, int n2, int n3) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid value for dataType!");
        }
        if (n2 < 0 || n2 > n3) {
            throw new IllegalArgumentException("Invalid list bounds!");
        }
        Attribute attribute = new Attribute();
        attribute.attrName = string2;
        attribute.valueType = 32;
        attribute.dataType = n;
        attribute.required = bl;
        attribute.listMinLength = n2;
        attribute.listMaxLength = n3;
        element.attrList.add(string2);
        element.attrMap.put(string2, attribute);
    }

    protected void addBooleanAttribute(String string, String string2, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TRUE");
        arrayList.add("FALSE");
        String string3 = null;
        if (bl) {
            string3 = bl2 ? "TRUE" : "FALSE";
        }
        this.addAttribute(string, string2, 1, true, string3, arrayList);
    }

    protected void removeAttribute(String string, String string2) {
        Element element = this.getElement(string);
        element.attrList.remove(string2);
        element.attrMap.remove(string2);
    }

    protected <T> void addObjectValue(String string, Class<T> clazz, boolean bl, T t) {
        Element element = this.getElement(string);
        ObjectValue objectValue = new ObjectValue();
        objectValue.valueType = 1;
        objectValue.classType = clazz;
        objectValue.defaultValue = t;
        element.objectValue = objectValue;
    }

    protected <T> void addObjectValue(String string, Class<T> clazz, boolean bl, T t, List<? extends T> list) {
        Object object2;
        Element element = this.getElement(string);
        if (list == null) {
            throw new IllegalArgumentException("enumeratedValues == null!");
        }
        if (list.size() == 0) {
            throw new IllegalArgumentException("enumeratedValues is empty!");
        }
        for (Object object2 : list) {
            if (object2 == null) {
                throw new IllegalArgumentException("enumeratedValues contains a null!");
            }
            if (clazz.isInstance(object2)) continue;
            throw new IllegalArgumentException("enumeratedValues contains a value not of class classType!");
        }
        object2 = new ObjectValue();
        ((ObjectValue)object2).valueType = 16;
        ((ObjectValue)object2).classType = clazz;
        ((ObjectValue)object2).defaultValue = t;
        ((ObjectValue)object2).enumeratedValues = list;
        element.objectValue = object2;
    }

    protected <T> void addObjectValue(String string, Class<T> clazz, T t, Comparable<? super T> comparable, Comparable<? super T> comparable2, boolean bl, boolean bl2) {
        Element element = this.getElement(string);
        ObjectValue objectValue = new ObjectValue();
        objectValue.valueType = 2;
        if (bl) {
            objectValue.valueType |= 4;
        }
        if (bl2) {
            objectValue.valueType |= 8;
        }
        objectValue.classType = clazz;
        objectValue.defaultValue = t;
        objectValue.minValue = comparable;
        objectValue.maxValue = comparable2;
        element.objectValue = objectValue;
    }

    protected void addObjectValue(String string, Class<?> clazz, int n, int n2) {
        Element element = this.getElement(string);
        ObjectValue objectValue = new ObjectValue();
        objectValue.valueType = 32;
        objectValue.classType = clazz;
        objectValue.arrayMinLength = n;
        objectValue.arrayMaxLength = n2;
        element.objectValue = objectValue;
    }

    protected void removeObjectValue(String string) {
        Element element = this.getElement(string);
        element.objectValue = null;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public abstract boolean canNodeAppear(String var1, ImageTypeSpecifier var2);

    @Override
    public int getElementMinChildren(String string) {
        Element element = this.getElement(string);
        if (element.childPolicy != 5) {
            throw new IllegalArgumentException("Child policy not CHILD_POLICY_REPEAT!");
        }
        return element.minChildren;
    }

    @Override
    public int getElementMaxChildren(String string) {
        Element element = this.getElement(string);
        if (element.childPolicy != 5) {
            throw new IllegalArgumentException("Child policy not CHILD_POLICY_REPEAT!");
        }
        return element.maxChildren;
    }

    private String getResource(String string, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(this.resourceBaseName, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                resourceBundle = ResourceBundle.getBundle(this.resourceBaseName, locale);
            }
            catch (MissingResourceException missingResourceException2) {
                return null;
            }
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Override
    public String getElementDescription(String string, Locale locale) {
        Element element = this.getElement(string);
        return this.getResource(string, locale);
    }

    @Override
    public int getChildPolicy(String string) {
        Element element = this.getElement(string);
        return element.childPolicy;
    }

    @Override
    public String[] getChildNames(String string) {
        Element element = this.getElement(string);
        if (element.childPolicy == 0) {
            return null;
        }
        return element.childList.toArray(new String[0]);
    }

    @Override
    public String[] getAttributeNames(String string) {
        Element element = this.getElement(string);
        List list = element.attrList;
        String[] stringArray = new String[list.size()];
        return list.toArray(stringArray);
    }

    @Override
    public int getAttributeValueType(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.valueType;
    }

    @Override
    public int getAttributeDataType(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.dataType;
    }

    @Override
    public boolean isAttributeRequired(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.required;
    }

    @Override
    public String getAttributeDefaultValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        return attribute.defaultValue;
    }

    @Override
    public String[] getAttributeEnumerations(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 16) {
            throw new IllegalArgumentException("Attribute not an enumeration!");
        }
        List list = attribute.enumeratedValues;
        Iterator iterator = list.iterator();
        String[] stringArray = new String[list.size()];
        return list.toArray(stringArray);
    }

    @Override
    public String getAttributeMinValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 2 && attribute.valueType != 6 && attribute.valueType != 10 && attribute.valueType != 14) {
            throw new IllegalArgumentException("Attribute not a range!");
        }
        return attribute.minValue;
    }

    @Override
    public String getAttributeMaxValue(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 2 && attribute.valueType != 6 && attribute.valueType != 10 && attribute.valueType != 14) {
            throw new IllegalArgumentException("Attribute not a range!");
        }
        return attribute.maxValue;
    }

    @Override
    public int getAttributeListMinLength(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 32) {
            throw new IllegalArgumentException("Attribute not a list!");
        }
        return attribute.listMinLength;
    }

    @Override
    public int getAttributeListMaxLength(String string, String string2) {
        Attribute attribute = this.getAttribute(string, string2);
        if (attribute.valueType != 32) {
            throw new IllegalArgumentException("Attribute not a list!");
        }
        return attribute.listMaxLength;
    }

    @Override
    public String getAttributeDescription(String string, String string2, Locale locale) {
        Element element = this.getElement(string);
        if (string2 == null) {
            throw new IllegalArgumentException("attrName == null!");
        }
        Attribute attribute = (Attribute)element.attrMap.get(string2);
        if (attribute == null) {
            throw new IllegalArgumentException("No such attribute!");
        }
        String string3 = string + "/" + string2;
        return this.getResource(string3, locale);
    }

    private ObjectValue getObjectValue(String string) {
        Element element = this.getElement(string);
        ObjectValue objectValue = element.objectValue;
        if (objectValue == null) {
            throw new IllegalArgumentException("No object within element " + string + "!");
        }
        return objectValue;
    }

    @Override
    public int getObjectValueType(String string) {
        Element element = this.getElement(string);
        ObjectValue objectValue = element.objectValue;
        if (objectValue == null) {
            return 0;
        }
        return objectValue.valueType;
    }

    @Override
    public Class<?> getObjectClass(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        return objectValue.classType;
    }

    @Override
    public Object getObjectDefaultValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        return objectValue.defaultValue;
    }

    @Override
    public Object[] getObjectEnumerations(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 16) {
            throw new IllegalArgumentException("Not an enumeration!");
        }
        List list = objectValue.enumeratedValues;
        Object[] objectArray = new Object[list.size()];
        return list.toArray(objectArray);
    }

    @Override
    public Comparable<?> getObjectMinValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if ((objectValue.valueType & 2) != 2) {
            throw new IllegalArgumentException("Not a range!");
        }
        return objectValue.minValue;
    }

    @Override
    public Comparable<?> getObjectMaxValue(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if ((objectValue.valueType & 2) != 2) {
            throw new IllegalArgumentException("Not a range!");
        }
        return objectValue.maxValue;
    }

    @Override
    public int getObjectArrayMinLength(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 32) {
            throw new IllegalArgumentException("Not a list!");
        }
        return objectValue.arrayMinLength;
    }

    @Override
    public int getObjectArrayMaxLength(String string) {
        ObjectValue objectValue = this.getObjectValue(string);
        if (objectValue.valueType != 32) {
            throw new IllegalArgumentException("Not a list!");
        }
        return objectValue.arrayMaxLength;
    }

    private static synchronized void createStandardFormat() {
        if (standardFormat == null) {
            standardFormat = new StandardMetadataFormat();
        }
    }

    public static IIOMetadataFormat getStandardFormatInstance() {
        IIOMetadataFormatImpl.createStandardFormat();
        return standardFormat;
    }

    class Attribute {
        String attrName;
        int valueType = 1;
        int dataType;
        boolean required;
        String defaultValue = null;
        List enumeratedValues;
        String minValue;
        String maxValue;
        int listMinLength;
        int listMaxLength;

        Attribute() {
        }
    }

    class Element {
        String elementName;
        int childPolicy;
        int minChildren = 0;
        int maxChildren = 0;
        List childList = new ArrayList();
        List parentList = new ArrayList();
        List attrList = new ArrayList();
        Map attrMap = new HashMap();
        ObjectValue objectValue;

        Element() {
        }
    }

    class ObjectValue {
        int valueType = 0;
        Class classType = null;
        Object defaultValue = null;
        List enumeratedValues = null;
        Comparable minValue = null;
        Comparable maxValue = null;
        int arrayMinLength = 0;
        int arrayMaxLength = 0;

        ObjectValue() {
        }
    }
}

