/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.resolver;

import com.sun.org.apache.xerces.internal.utils.SecuritySupport;
import com.sun.org.apache.xml.internal.resolver.Catalog;
import com.sun.org.apache.xml.internal.resolver.helpers.BootstrapResolver;
import com.sun.org.apache.xml.internal.resolver.helpers.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.reflect.misc.ReflectUtil;

public class CatalogManager {
    private static final String pFiles = "xml.catalog.files";
    private static final String pVerbosity = "xml.catalog.verbosity";
    private static final String pPrefer = "xml.catalog.prefer";
    private static final String pStatic = "xml.catalog.staticCatalog";
    private static final String pAllowPI = "xml.catalog.allowPI";
    private static final String pClassname = "xml.catalog.className";
    private static final String pIgnoreMissing = "xml.catalog.ignoreMissing";
    private static final CatalogManager staticManager = new CatalogManager();
    private BootstrapResolver bResolver = new BootstrapResolver();
    private boolean ignoreMissingProperties = SecuritySupport.getSystemProperty("xml.catalog.ignoreMissing") != null || SecuritySupport.getSystemProperty("xml.catalog.files") != null;
    private ResourceBundle resources;
    private String propertyFile = "CatalogManager.properties";
    private URL propertyFileURI = null;
    private String defaultCatalogFiles = "./xcatalog";
    private String catalogFiles = null;
    private boolean fromPropertiesFile = false;
    private int defaultVerbosity = 1;
    private Integer verbosity = null;
    private boolean defaultPreferPublic = true;
    private Boolean preferPublic = null;
    private boolean defaultUseStaticCatalog = true;
    private Boolean useStaticCatalog = null;
    private static volatile Catalog staticCatalog = null;
    private boolean defaultOasisXMLCatalogPI = true;
    private Boolean oasisXMLCatalogPI = null;
    private boolean defaultRelativeCatalogs = true;
    private Boolean relativeCatalogs = null;
    private String catalogClassName = null;
    private boolean overrideDefaultParser;
    public Debug debug = null;

    public CatalogManager() {
        this.init();
    }

    public CatalogManager(String string) {
        this.propertyFile = string;
        this.init();
    }

    private void init() {
        this.debug = new Debug();
        if (System.getSecurityManager() == null) {
            this.overrideDefaultParser = true;
        }
        this.queryVerbosityFromSysProp();
    }

    public void setBootstrapResolver(BootstrapResolver bootstrapResolver) {
        this.bResolver = bootstrapResolver;
    }

    public BootstrapResolver getBootstrapResolver() {
        return this.bResolver;
    }

    private void queryVerbosityFromSysProp() {
        String string = SecuritySupport.getSystemProperty(pVerbosity);
        if (string != null) {
            try {
                int n = Integer.parseInt(string.trim());
                this.verbosity = new Integer(n);
                this.debug.setDebug(n);
            }
            catch (Exception exception) {
                System.err.println("Cannot parse verbosity: \"" + string + "\"");
            }
        }
    }

    private synchronized void readProperties() {
        Object object;
        block9: {
            try {
                this.propertyFileURI = CatalogManager.class.getResource("/" + this.propertyFile);
                object = CatalogManager.class.getResourceAsStream("/" + this.propertyFile);
                if (object == null) {
                    if (!this.ignoreMissingProperties) {
                        System.err.println("Cannot find " + this.propertyFile);
                        this.ignoreMissingProperties = true;
                    }
                    return;
                }
                this.resources = new PropertyResourceBundle((InputStream)object);
            }
            catch (MissingResourceException missingResourceException) {
                if (!this.ignoreMissingProperties) {
                    System.err.println("Cannot read " + this.propertyFile);
                }
            }
            catch (IOException iOException) {
                if (this.ignoreMissingProperties) break block9;
                System.err.println("Failure trying to read " + this.propertyFile);
            }
        }
        if (this.verbosity == null) {
            try {
                object = this.resources.getString("verbosity");
                int n = Integer.parseInt(((String)object).trim());
                this.debug.setDebug(n);
                this.verbosity = new Integer(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static CatalogManager getStaticManager() {
        return staticManager;
    }

    public boolean getIgnoreMissingProperties() {
        return this.ignoreMissingProperties;
    }

    public void setIgnoreMissingProperties(boolean bl) {
        this.ignoreMissingProperties = bl;
    }

    public void ignoreMissingProperties(boolean bl) {
        this.setIgnoreMissingProperties(bl);
    }

    private int queryVerbosity() {
        String string = Integer.toString(this.defaultVerbosity);
        String string2 = SecuritySupport.getSystemProperty(pVerbosity);
        if (string2 == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources != null) {
                try {
                    string2 = this.resources.getString("verbosity");
                }
                catch (MissingResourceException missingResourceException) {
                    string2 = string;
                }
            } else {
                string2 = string;
            }
        }
        int n = this.defaultVerbosity;
        try {
            n = Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            System.err.println("Cannot parse verbosity: \"" + string2 + "\"");
        }
        if (this.verbosity == null) {
            this.debug.setDebug(n);
            this.verbosity = new Integer(n);
        }
        return n;
    }

    public int getVerbosity() {
        if (this.verbosity == null) {
            this.verbosity = new Integer(this.queryVerbosity());
        }
        return this.verbosity;
    }

    public void setVerbosity(int n) {
        this.verbosity = new Integer(n);
        this.debug.setDebug(n);
    }

    public int verbosity() {
        return this.getVerbosity();
    }

    private boolean queryRelativeCatalogs() {
        if (this.resources == null) {
            this.readProperties();
        }
        if (this.resources == null) {
            return this.defaultRelativeCatalogs;
        }
        try {
            String string = this.resources.getString("relative-catalogs");
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
        }
        catch (MissingResourceException missingResourceException) {
            return this.defaultRelativeCatalogs;
        }
    }

    public boolean getRelativeCatalogs() {
        if (this.relativeCatalogs == null) {
            this.relativeCatalogs = this.queryRelativeCatalogs() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.relativeCatalogs;
    }

    public void setRelativeCatalogs(boolean bl) {
        this.relativeCatalogs = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean relativeCatalogs() {
        return this.getRelativeCatalogs();
    }

    private String queryCatalogFiles() {
        String string = SecuritySupport.getSystemProperty(pFiles);
        this.fromPropertiesFile = false;
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources != null) {
                try {
                    string = this.resources.getString("catalogs");
                    this.fromPropertiesFile = true;
                }
                catch (MissingResourceException missingResourceException) {
                    System.err.println(this.propertyFile + ": catalogs not found.");
                    string = null;
                }
            }
        }
        if (string == null) {
            string = this.defaultCatalogFiles;
        }
        return string;
    }

    public Vector getCatalogFiles() {
        if (this.catalogFiles == null) {
            this.catalogFiles = this.queryCatalogFiles();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.catalogFiles, ";");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            URL uRL = null;
            if (this.fromPropertiesFile && !this.relativeCatalogs()) {
                try {
                    uRL = new URL(this.propertyFileURI, string);
                    string = uRL.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
            }
            vector.add(string);
        }
        return vector;
    }

    public void setCatalogFiles(String string) {
        this.catalogFiles = string;
        this.fromPropertiesFile = false;
    }

    public Vector catalogFiles() {
        return this.getCatalogFiles();
    }

    private boolean queryPreferPublic() {
        String string = SecuritySupport.getSystemProperty(pPrefer);
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultPreferPublic;
            }
            try {
                string = this.resources.getString("prefer");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultPreferPublic;
            }
        }
        if (string == null) {
            return this.defaultPreferPublic;
        }
        return string.equalsIgnoreCase("public");
    }

    public boolean getPreferPublic() {
        if (this.preferPublic == null) {
            this.preferPublic = this.queryPreferPublic() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.preferPublic;
    }

    public void setPreferPublic(boolean bl) {
        this.preferPublic = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean preferPublic() {
        return this.getPreferPublic();
    }

    private boolean queryUseStaticCatalog() {
        String string = SecuritySupport.getSystemProperty(pStatic);
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultUseStaticCatalog;
            }
            try {
                string = this.resources.getString("static-catalog");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultUseStaticCatalog;
            }
        }
        if (string == null) {
            return this.defaultUseStaticCatalog;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
    }

    public boolean getUseStaticCatalog() {
        if (this.useStaticCatalog == null) {
            this.useStaticCatalog = this.queryUseStaticCatalog() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.useStaticCatalog;
    }

    public void setUseStaticCatalog(boolean bl) {
        this.useStaticCatalog = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean staticCatalog() {
        return this.getUseStaticCatalog();
    }

    public Catalog getPrivateCatalog() {
        Catalog catalog = staticCatalog;
        if (this.useStaticCatalog == null) {
            Boolean bl = this.useStaticCatalog = this.getUseStaticCatalog() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (catalog == null || !this.useStaticCatalog.booleanValue()) {
            try {
                String string = this.getCatalogClassName();
                if (string == null) {
                    catalog = new Catalog();
                } else {
                    try {
                        catalog = (Catalog)ReflectUtil.forName(string).newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.debug.message(1, "Catalog class named '" + string + "' could not be found. Using default.");
                        catalog = new Catalog();
                    }
                    catch (ClassCastException classCastException) {
                        this.debug.message(1, "Class named '" + string + "' is not a Catalog. Using default.");
                        catalog = new Catalog();
                    }
                }
                catalog.setCatalogManager(this);
                catalog.setupReaders();
                catalog.loadSystemCatalogs();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.useStaticCatalog.booleanValue()) {
                staticCatalog = catalog;
            }
        }
        return catalog;
    }

    public Catalog getCatalog() {
        Catalog catalog = staticCatalog;
        if (this.useStaticCatalog == null) {
            Boolean bl = this.useStaticCatalog = this.getUseStaticCatalog() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (catalog == null || !this.useStaticCatalog.booleanValue()) {
            catalog = this.getPrivateCatalog();
            if (this.useStaticCatalog.booleanValue()) {
                staticCatalog = catalog;
            }
        }
        return catalog;
    }

    public boolean queryAllowOasisXMLCatalogPI() {
        String string = SecuritySupport.getSystemProperty(pAllowPI);
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return this.defaultOasisXMLCatalogPI;
            }
            try {
                string = this.resources.getString("allow-oasis-xml-catalog-pi");
            }
            catch (MissingResourceException missingResourceException) {
                return this.defaultOasisXMLCatalogPI;
            }
        }
        if (string == null) {
            return this.defaultOasisXMLCatalogPI;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
    }

    public boolean getAllowOasisXMLCatalogPI() {
        if (this.oasisXMLCatalogPI == null) {
            this.oasisXMLCatalogPI = this.queryAllowOasisXMLCatalogPI() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.oasisXMLCatalogPI;
    }

    public boolean overrideDefaultParser() {
        return this.overrideDefaultParser;
    }

    public void setAllowOasisXMLCatalogPI(boolean bl) {
        this.oasisXMLCatalogPI = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean allowOasisXMLCatalogPI() {
        return this.getAllowOasisXMLCatalogPI();
    }

    public String queryCatalogClassName() {
        String string = SecuritySupport.getSystemProperty(pClassname);
        if (string == null) {
            if (this.resources == null) {
                this.readProperties();
            }
            if (this.resources == null) {
                return null;
            }
            try {
                return this.resources.getString("catalog-class-name");
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
        return string;
    }

    public String getCatalogClassName() {
        if (this.catalogClassName == null) {
            this.catalogClassName = this.queryCatalogClassName();
        }
        return this.catalogClassName;
    }

    public void setCatalogClassName(String string) {
        this.catalogClassName = string;
    }

    public String catalogClassName() {
        return this.getCatalogClassName();
    }
}

