/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.EmptyVisitor;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class BCELifier
extends EmptyVisitor {
    private static final String BASE_PACKAGE = Const.class.getPackage().getName();
    private static final String CONSTANT_PREFIX = Const.class.getSimpleName() + ".";
    private final JavaClass clazz;
    private final PrintWriter printWriter;
    private final ConstantPoolGen constantPoolGen;

    static JavaClass getJavaClass(String string) throws ClassNotFoundException, IOException {
        JavaClass javaClass = Repository.lookupClass(string);
        if (javaClass == null) {
            javaClass = new ClassParser(string).parse();
        }
        return javaClass;
    }

    public static void _main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.out.println("Usage: BCELifier className");
            System.out.println("\tThe class must exist on the classpath");
            return;
        }
        BCELifier bCELifier = new BCELifier(BCELifier.getJavaClass(stringArray[0]), System.out);
        bCELifier.start();
    }

    static String printArgumentTypes(Type[] typeArray) {
        if (typeArray.length == 0) {
            return "Type.NO_ARGS";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < typeArray.length; ++i) {
            stringBuilder.append(BCELifier.printType(typeArray[i]));
            if (i >= typeArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return "new Type[] { " + stringBuilder.toString() + " }";
    }

    static String printFlags(int n) {
        return BCELifier.printFlags(n, FLAGS.UNKNOWN);
    }

    public static String printFlags(int n, FLAGS fLAGS) {
        if (n == 0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 1;
        while (n3 <= 32768) {
            if ((n & n3) != 0) {
                if (n3 == 32 && fLAGS == FLAGS.CLASS) {
                    stringBuilder.append(CONSTANT_PREFIX).append("ACC_SUPER | ");
                } else if (n3 == 64 && fLAGS == FLAGS.METHOD) {
                    stringBuilder.append(CONSTANT_PREFIX).append("ACC_BRIDGE | ");
                } else if (n3 == 128 && fLAGS == FLAGS.METHOD) {
                    stringBuilder.append(CONSTANT_PREFIX).append("ACC_VARARGS | ");
                } else if (n2 < Const.ACCESS_NAMES_LENGTH) {
                    stringBuilder.append(CONSTANT_PREFIX).append("ACC_").append(Const.getAccessName(n2).toUpperCase(Locale.ENGLISH)).append(" | ");
                } else {
                    stringBuilder.append(String.format(CONSTANT_PREFIX + "ACC_BIT %x | ", n3));
                }
            }
            n3 <<= 1;
            ++n2;
        }
        String string = stringBuilder.toString();
        return string.substring(0, string.length() - 3);
    }

    static String printType(String string) {
        Type type = Type.getType(string);
        byte by = type.getType();
        if (by <= 12) {
            return "Type." + Const.getTypeName(by).toUpperCase(Locale.ENGLISH);
        }
        if (type.toString().equals("java.lang.String")) {
            return "Type.STRING";
        }
        if (type.toString().equals("java.lang.Object")) {
            return "Type.OBJECT";
        }
        if (type.toString().equals("java.lang.StringBuffer")) {
            return "Type.STRINGBUFFER";
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return "new ArrayType(" + BCELifier.printType(arrayType.getBasicType()) + ", " + arrayType.getDimensions() + ")";
        }
        return "new ObjectType(\"" + Utility.signatureToString(string, false) + "\")";
    }

    static String printType(Type type) {
        return BCELifier.printType(type.getSignature());
    }

    public BCELifier(JavaClass javaClass, OutputStream outputStream) {
        this.clazz = javaClass;
        this.printWriter = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), false);
        this.constantPoolGen = new ConstantPoolGen(this.clazz.getConstantPool());
    }

    private void printCreate() {
        this.printWriter.println("  public void create(OutputStream out) throws IOException {");
        Field[] fieldArray = this.clazz.getFields();
        if (fieldArray.length > 0) {
            this.printWriter.println("    createFields();");
        }
        Method[] methodArray = this.clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.printWriter.println("    createMethod_" + i + "();");
        }
        this.printWriter.println("    _cg.getJavaClass().dump(out);");
        this.printWriter.println("  }");
        this.printWriter.println();
    }

    private void printMain() {
        String string = this.clazz.getClassName();
        this.printWriter.println("  public static void main(String[] args) throws Exception {");
        this.printWriter.println("    " + string + "Creator creator = new " + string + "Creator();");
        this.printWriter.println("    creator.create(new FileOutputStream(\"" + string + ".class\"));");
        this.printWriter.println("  }");
    }

    public void start() {
        this.visitJavaClass(this.clazz);
        this.printWriter.flush();
    }

    @Override
    public void visitField(Field field) {
        this.printWriter.println();
        this.printWriter.println("    field = new FieldGen(" + BCELifier.printFlags(field.getAccessFlags()) + ", " + BCELifier.printType(field.getSignature()) + ", \"" + field.getName() + "\", _cp);");
        ConstantValue constantValue = field.getConstantValue();
        if (constantValue != null) {
            this.printWriter.print("    field.setInitValue(");
            if (field.getType() == Type.CHAR) {
                this.printWriter.print("(char)");
            }
            if (field.getType() == Type.SHORT) {
                this.printWriter.print("(short)");
            }
            if (field.getType() == Type.BYTE) {
                this.printWriter.print("(byte)");
            }
            this.printWriter.print(constantValue);
            if (field.getType() == Type.LONG) {
                this.printWriter.print("L");
            }
            if (field.getType() == Type.FLOAT) {
                this.printWriter.print("F");
            }
            if (field.getType() == Type.DOUBLE) {
                this.printWriter.print("D");
            }
            this.printWriter.println(");");
        }
        this.printWriter.println("    _cg.addField(field.getField());");
    }

    @Override
    public void visitJavaClass(JavaClass javaClass) {
        String string = javaClass.getClassName();
        String string2 = javaClass.getSuperclassName();
        String string3 = javaClass.getPackageName();
        String string4 = Utility.printArray(javaClass.getInterfaceNames(), false, true);
        if (string3 != null && !string3.trim().isEmpty()) {
            string = string.substring(string3.length() + 1);
            this.printWriter.println("package " + string3 + ";");
            this.printWriter.println();
        }
        this.printWriter.println("import " + BASE_PACKAGE + ".generic.*;");
        this.printWriter.println("import " + BASE_PACKAGE + ".classfile.*;");
        this.printWriter.println("import " + BASE_PACKAGE + ".*;");
        this.printWriter.println("import java.io.*;");
        this.printWriter.println();
        this.printWriter.println("public class " + string + "Creator {");
        this.printWriter.println("  private InstructionFactory _factory;");
        this.printWriter.println("  private ConstantPoolGen    _cp;");
        this.printWriter.println("  private ClassGen           _cg;");
        this.printWriter.println();
        this.printWriter.println("  public " + string + "Creator() {");
        this.printWriter.println("    _cg = new ClassGen(\"" + (string3.isEmpty() ? string : string3 + "." + string) + "\", \"" + string2 + "\", \"" + javaClass.getSourceFileName() + "\", " + BCELifier.printFlags(javaClass.getAccessFlags(), FLAGS.CLASS) + ", new String[] { " + string4 + " });");
        this.printWriter.println("    _cg.setMajor(" + javaClass.getMajor() + ");");
        this.printWriter.println("    _cg.setMinor(" + javaClass.getMinor() + ");");
        this.printWriter.println();
        this.printWriter.println("    _cp = _cg.getConstantPool();");
        this.printWriter.println("    _factory = new InstructionFactory(_cg, _cp);");
        this.printWriter.println("  }");
        this.printWriter.println();
        this.printCreate();
        Field[] fieldArray = javaClass.getFields();
        if (fieldArray.length > 0) {
            this.printWriter.println("  private void createFields() {");
            this.printWriter.println("    FieldGen field;");
            for (FieldOrMethod fieldOrMethod : fieldArray) {
                ((Field)fieldOrMethod).accept(this);
            }
            this.printWriter.println("  }");
            this.printWriter.println();
        }
        FieldOrMethod[] fieldOrMethodArray = javaClass.getMethods();
        for (int i = 0; i < fieldOrMethodArray.length; ++i) {
            this.printWriter.println("  private void createMethod_" + i + "() {");
            ((Method)fieldOrMethodArray[i]).accept(this);
            this.printWriter.println("  }");
            this.printWriter.println();
        }
        this.printMain();
        this.printWriter.println("}");
    }

    @Override
    public void visitMethod(Method method) {
        Object object;
        MethodGen methodGen = new MethodGen(method, this.clazz.getClassName(), this.constantPoolGen);
        this.printWriter.println("    InstructionList il = new InstructionList();");
        this.printWriter.println("    MethodGen method = new MethodGen(" + BCELifier.printFlags(method.getAccessFlags(), FLAGS.METHOD) + ", " + BCELifier.printType(methodGen.getReturnType()) + ", " + BCELifier.printArgumentTypes(methodGen.getArgumentTypes()) + ", new String[] { " + Utility.printArray(methodGen.getArgumentNames(), false, true) + " }, \"" + method.getName() + "\", \"" + this.clazz.getClassName() + "\", il, _cp);");
        ExceptionTable exceptionTable = method.getExceptionTable();
        if (exceptionTable != null) {
            object = exceptionTable.getExceptionNames();
            for (String string : object) {
                this.printWriter.print("    method.addException(\"");
                this.printWriter.print(string);
                this.printWriter.println("\");");
            }
        }
        this.printWriter.println();
        object = new BCELFactory(methodGen, this.printWriter);
        ((BCELFactory)object).start();
        this.printWriter.println("    method.setMaxStack();");
        this.printWriter.println("    method.setMaxLocals();");
        this.printWriter.println("    _cg.addMethod(method.getMethod());");
        this.printWriter.println("    il.dispose();");
    }

    public static enum FLAGS {
        UNKNOWN,
        CLASS,
        METHOD;

    }
}

