/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BranchInstruction
extends Instruction
implements InstructionTargeter {
    @Deprecated
    protected int index;
    @Deprecated
    protected InstructionHandle target;
    @Deprecated
    protected int position;

    static void notifyTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionTargeter instructionTargeter) {
        if (instructionHandle != null) {
            instructionHandle.removeTargeter(instructionTargeter);
        }
        if (instructionHandle2 != null) {
            instructionHandle2.addTargeter(instructionTargeter);
        }
    }

    BranchInstruction() {
    }

    protected BranchInstruction(short s, InstructionHandle instructionHandle) {
        super(s, (short)3);
        this.setTarget(instructionHandle);
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.target == instructionHandle;
    }

    @Override
    void dispose() {
        this.setTarget(null);
        this.index = -1;
        this.position = -1;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getOpcode());
        this.index = this.getTargetOffset();
        if (!BranchInstruction.isValidShort(this.index)) {
            throw new ClassGenException("Branch target offset too large for short: " + this.index);
        }
        dataOutputStream.writeShort(this.index);
    }

    public final int getIndex() {
        return this.index;
    }

    protected int getPosition() {
        return this.position;
    }

    public InstructionHandle getTarget() {
        return this.target;
    }

    protected int getTargetOffset() {
        return this.getTargetOffset(this.target);
    }

    protected int getTargetOffset(InstructionHandle instructionHandle) {
        if (instructionHandle == null) {
            throw new ClassGenException("Target of " + super.toString(true) + " is invalid null handle");
        }
        int n = instructionHandle.getPosition();
        if (n < 0) {
            throw new ClassGenException("Invalid branch target position offset for " + super.toString(true) + ":" + n + ":" + instructionHandle);
        }
        return n - this.position;
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        super.setLength(3);
        this.index = byteSequence.readShort();
    }

    protected void setIndex(int n) {
        this.index = n;
    }

    protected void setPosition(int n) {
        this.position = n;
    }

    @Override
    void setOpcode(short s) {
        if (this.target == null) {
            super.setOpcode(s);
        } else {
            InstructionHandle instructionHandle = this.target;
            this.setTarget(null);
            super.setOpcode(s);
            this.setTarget(instructionHandle);
        }
    }

    public void setTarget(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.target, instructionHandle, this);
        this.target = instructionHandle;
    }

    @Override
    public String toString(boolean bl) {
        String string = super.toString(bl);
        String string2 = "null";
        if (this.target != null) {
            if (bl) {
                string2 = this.target.getInstruction() == this ? "<points to itself>" : (this.target.getInstruction() == null ? "<null instruction!!!?>" : "" + this.target.getPosition());
            } else {
                this.index = this.target.getPosition();
                string2 = "" + this.index;
            }
        }
        return string + " -> " + string2;
    }

    protected int updatePosition(int n, int n2) {
        this.position += n;
        return 0;
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (this.target != instructionHandle) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but " + this.target);
        }
        this.setTarget(instructionHandle2);
    }
}

