/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.StackMapEntry;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMap
extends Attribute {
    private StackMapEntry[] table;

    StackMap(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (StackMapEntry[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.table = new StackMapEntry[n3];
        for (int i = 0; i < n3; ++i) {
            this.table[i] = new StackMapEntry(dataInput, constantPool);
        }
    }

    public StackMap(int n, int n2, StackMapEntry[] stackMapEntryArray, ConstantPool constantPool) {
        super((byte)11, n, n2, constantPool);
        this.table = stackMapEntryArray != null ? stackMapEntryArray : StackMapEntry.EMPTY_ARRAY;
        Args.requireU2(this.table.length, "table.length");
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStackMap(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        StackMap stackMap = (StackMap)this.clone();
        stackMap.table = new StackMapEntry[this.table.length];
        for (int i = 0; i < this.table.length; ++i) {
            stackMap.table[i] = this.table[i].copy();
        }
        stackMap.setConstantPool(constantPool);
        return stackMap;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.table.length);
        for (StackMapEntry stackMapEntry : this.table) {
            stackMapEntry.dump(dataOutputStream);
        }
    }

    public int getMapLength() {
        return this.table.length;
    }

    public StackMapEntry[] getStackMap() {
        return this.table;
    }

    public void setStackMap(StackMapEntry[] stackMapEntryArray) {
        this.table = stackMapEntryArray != null ? stackMapEntryArray : StackMapEntry.EMPTY_ARRAY;
        int n = 2;
        for (StackMapEntry stackMapEntry : this.table) {
            n += stackMapEntry.getMapEntrySize();
        }
        this.setLength(n);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("StackMap(");
        int n = -1;
        for (int i = 0; i < this.table.length; ++i) {
            n = this.table[i].getByteCodeOffset() + n + 1;
            stringBuilder.append(String.format("%n@%03d %s", n, this.table[i]));
            if (i >= this.table.length - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

