/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleRequires
implements Cloneable,
Node {
    private final int requiresIndex;
    private final int requiresFlags;
    private final int requiresVersionIndex;

    ModuleRequires(DataInput dataInput) throws IOException {
        this.requiresIndex = dataInput.readUnsignedShort();
        this.requiresFlags = dataInput.readUnsignedShort();
        this.requiresVersionIndex = dataInput.readUnsignedShort();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleRequires(this);
    }

    public ModuleRequires copy() {
        try {
            return (ModuleRequires)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.requiresIndex);
        dataOutputStream.writeShort(this.requiresFlags);
        dataOutputStream.writeShort(this.requiresVersionIndex);
    }

    public String toString() {
        return "requires(" + this.requiresIndex + ", " + String.format("%04x", this.requiresFlags) + ", " + this.requiresVersionIndex + ")";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.requiresIndex, (byte)19);
        stringBuilder.append(Utility.compactClassName(string, false));
        stringBuilder.append(", ").append(String.format("%04x", this.requiresFlags));
        String string2 = this.requiresVersionIndex == 0 ? "0" : constantPool.getConstantString(this.requiresVersionIndex, (byte)1);
        stringBuilder.append(", ").append(string2);
        return stringBuilder.toString();
    }
}

