/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnclosingMethod
extends Attribute {
    private int classIndex;
    private int methodIndex;

    EnclosingMethod(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), constantPool);
    }

    private EnclosingMethod(int n, int n2, int n3, int n4, ConstantPool constantPool) {
        super((byte)18, n, Args.require(n2, 4, "EnclosingMethod attribute length"), constantPool);
        this.classIndex = Args.requireU2(n3, 0, constantPool.getLength(), "EnclosingMethod class index");
        this.methodIndex = Args.requireU2(n4, "EnclosingMethod method index");
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitEnclosingMethod(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (Attribute)this.clone();
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.classIndex);
        dataOutputStream.writeShort(this.methodIndex);
    }

    public final ConstantClass getEnclosingClass() {
        return super.getConstantPool().getConstant(this.classIndex, (byte)7, ConstantClass.class);
    }

    public final int getEnclosingClassIndex() {
        return this.classIndex;
    }

    public final ConstantNameAndType getEnclosingMethod() {
        if (this.methodIndex == 0) {
            return null;
        }
        return super.getConstantPool().getConstant(this.methodIndex, (byte)12, ConstantNameAndType.class);
    }

    public final int getEnclosingMethodIndex() {
        return this.methodIndex;
    }

    public final void setEnclosingClassIndex(int n) {
        this.classIndex = n;
    }

    public final void setEnclosingMethodIndex(int n) {
        this.methodIndex = n;
    }
}

