/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantValue
extends Attribute {
    private int constantValueIndex;

    public ConstantValue(ConstantValue constantValue) {
        this(constantValue.getNameIndex(), constantValue.getLength(), constantValue.getConstantValueIndex(), constantValue.getConstantPool());
    }

    ConstantValue(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), constantPool);
    }

    public ConstantValue(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)1, n, Args.require(n2, 2, "ConstantValue attribute length"), constantPool);
        this.constantValueIndex = n3;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantValue(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        ConstantValue constantValue = (ConstantValue)this.clone();
        constantValue.setConstantPool(constantPool);
        return constantValue;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.constantValueIndex);
    }

    public int getConstantValueIndex() {
        return this.constantValueIndex;
    }

    public void setConstantValueIndex(int n) {
        this.constantValueIndex = n;
    }

    @Override
    public String toString() {
        String string;
        Object object = super.getConstantPool().getConstant(this.constantValueIndex);
        switch (((Constant)object).getTag()) {
            case 5: {
                string = String.valueOf(((ConstantLong)object).getBytes());
                break;
            }
            case 4: {
                string = String.valueOf(((ConstantFloat)object).getBytes());
                break;
            }
            case 6: {
                string = String.valueOf(((ConstantDouble)object).getBytes());
                break;
            }
            case 3: {
                string = String.valueOf(((ConstantInteger)object).getBytes());
                break;
            }
            case 8: {
                int n = ((ConstantString)object).getStringIndex();
                object = super.getConstantPool().getConstantUtf8(n);
                string = "\"" + Utility.convertString(((ConstantUtf8)object).getBytes()) + "\"";
                break;
            }
            default: {
                throw new IllegalStateException("Type of ConstValue invalid: " + object);
            }
        }
        return string;
    }
}

