/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantFloat
extends Constant
implements ConstantObject {
    private float bytes;

    public ConstantFloat(ConstantFloat constantFloat) {
        this(constantFloat.getBytes());
    }

    ConstantFloat(DataInput dataInput) throws IOException {
        this(dataInput.readFloat());
    }

    public ConstantFloat(float f) {
        super((byte)4);
        this.bytes = f;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantFloat(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getTag());
        dataOutputStream.writeFloat(this.bytes);
    }

    public float getBytes() {
        return this.bytes;
    }

    @Override
    public Object getConstantValue(ConstantPool constantPool) {
        return Float.valueOf(this.bytes);
    }

    public void setBytes(float f) {
        this.bytes = f;
    }

    @Override
    public String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }
}

