/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Const;
import com.sun.org.apache.bcel.internal.classfile.AnnotationDefault;
import com.sun.org.apache.bcel.internal.classfile.BootstrapMethods;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Deprecated;
import com.sun.org.apache.bcel.internal.classfile.EnclosingMethod;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTypeTable;
import com.sun.org.apache.bcel.internal.classfile.MethodParameters;
import com.sun.org.apache.bcel.internal.classfile.Module;
import com.sun.org.apache.bcel.internal.classfile.ModuleMainClass;
import com.sun.org.apache.bcel.internal.classfile.ModulePackages;
import com.sun.org.apache.bcel.internal.classfile.NestHost;
import com.sun.org.apache.bcel.internal.classfile.NestMembers;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.PMGClass;
import com.sun.org.apache.bcel.internal.classfile.RuntimeInvisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeInvisibleParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.StackMap;
import com.sun.org.apache.bcel.internal.classfile.Synthetic;
import com.sun.org.apache.bcel.internal.classfile.Unknown;
import com.sun.org.apache.bcel.internal.classfile.UnknownAttributeReader;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Attribute
implements Cloneable,
Node {
    private static final boolean debug = false;
    private static final Map<String, Object> READERS = new HashMap<String, Object>();
    public static final Attribute[] EMPTY_ARRAY = new Attribute[0];
    @java.lang.Deprecated
    protected int name_index;
    @java.lang.Deprecated
    protected int length;
    @java.lang.Deprecated
    protected byte tag;
    @java.lang.Deprecated
    protected ConstantPool constant_pool;

    public static void addAttributeReader(String string, UnknownAttributeReader unknownAttributeReader) {
        READERS.put(string, unknownAttributeReader);
    }

    protected static void println(String string) {
    }

    public static Attribute readAttribute(DataInput dataInput, ConstantPool constantPool) throws IOException {
        int n = -1;
        int n2 = dataInput.readUnsignedShort();
        String string = constantPool.getConstantUtf8(n2).getBytes();
        int n3 = dataInput.readInt();
        for (int n4 = 0; n4 < 27; n4 = (int)((byte)(n4 + 1))) {
            if (!string.equals(Const.getAttributeName(n4))) continue;
            n = n4;
            break;
        }
        switch (n) {
            case -1: {
                Object object = READERS.get(string);
                if (object instanceof UnknownAttributeReader) {
                    return ((UnknownAttributeReader)object).createAttribute(n2, n3, dataInput, constantPool);
                }
                return new Unknown(n2, n3, dataInput, constantPool);
            }
            case 1: {
                return new ConstantValue(n2, n3, dataInput, constantPool);
            }
            case 0: {
                return new SourceFile(n2, n3, dataInput, constantPool);
            }
            case 2: {
                return new Code(n2, n3, dataInput, constantPool);
            }
            case 3: {
                return new ExceptionTable(n2, n3, dataInput, constantPool);
            }
            case 4: {
                return new LineNumberTable(n2, n3, dataInput, constantPool);
            }
            case 5: {
                return new LocalVariableTable(n2, n3, dataInput, constantPool);
            }
            case 6: {
                return new InnerClasses(n2, n3, dataInput, constantPool);
            }
            case 7: {
                return new Synthetic(n2, n3, dataInput, constantPool);
            }
            case 8: {
                return new Deprecated(n2, n3, dataInput, constantPool);
            }
            case 9: {
                return new PMGClass(n2, n3, dataInput, constantPool);
            }
            case 10: {
                return new Signature(n2, n3, dataInput, constantPool);
            }
            case 11: {
                Attribute.println("Warning: Obsolete StackMap attribute ignored.");
                return new Unknown(n2, n3, dataInput, constantPool);
            }
            case 12: {
                return new RuntimeVisibleAnnotations(n2, n3, dataInput, constantPool);
            }
            case 13: {
                return new RuntimeInvisibleAnnotations(n2, n3, dataInput, constantPool);
            }
            case 14: {
                return new RuntimeVisibleParameterAnnotations(n2, n3, dataInput, constantPool);
            }
            case 15: {
                return new RuntimeInvisibleParameterAnnotations(n2, n3, dataInput, constantPool);
            }
            case 16: {
                return new AnnotationDefault(n2, n3, dataInput, constantPool);
            }
            case 17: {
                return new LocalVariableTypeTable(n2, n3, dataInput, constantPool);
            }
            case 18: {
                return new EnclosingMethod(n2, n3, dataInput, constantPool);
            }
            case 19: {
                return new StackMap(n2, n3, dataInput, constantPool);
            }
            case 20: {
                return new BootstrapMethods(n2, n3, dataInput, constantPool);
            }
            case 21: {
                return new MethodParameters(n2, n3, dataInput, constantPool);
            }
            case 22: {
                return new Module(n2, n3, dataInput, constantPool);
            }
            case 23: {
                return new ModulePackages(n2, n3, dataInput, constantPool);
            }
            case 24: {
                return new ModuleMainClass(n2, n3, dataInput, constantPool);
            }
            case 25: {
                return new NestHost(n2, n3, dataInput, constantPool);
            }
            case 26: {
                return new NestMembers(n2, n3, dataInput, constantPool);
            }
        }
        throw new IllegalStateException("Unrecognized attribute type tag parsed: " + n);
    }

    public static Attribute readAttribute(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        return Attribute.readAttribute((DataInput)dataInputStream, constantPool);
    }

    public static void removeAttributeReader(String string) {
        READERS.remove(string);
    }

    protected Attribute(byte by, int n, int n2, ConstantPool constantPool) {
        this.tag = by;
        this.name_index = Args.requireU2(n, 0, constantPool.getLength(), this.getClass().getSimpleName() + " name index");
        this.length = Args.requireU4(n2, this.getClass().getSimpleName() + " attribute length");
        this.constant_pool = constantPool;
    }

    @Override
    public abstract void accept(Visitor var1);

    public Object clone() {
        Attribute attribute = null;
        try {
            attribute = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
        return attribute;
    }

    public abstract Attribute copy(ConstantPool var1);

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeInt(this.length);
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final int getLength() {
        return this.length;
    }

    public String getName() {
        return this.constant_pool.getConstantUtf8(this.name_index).getBytes();
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public String toString() {
        return Const.getAttributeName(this.tag);
    }
}

