/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    static final int INSET = 3;
    static final long ListProc;
    static final TCHAR ListClass;

    static {
        ListClass = new TCHAR(0, "LISTBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0L, ListClass, wNDCLASS);
        ListProc = wNDCLASS.lpfnWndProc;
    }

    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n));
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = (int)OS.SendMessage(this.handle, 384, 0L, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == -1) {
            this.error(6);
        }
        if ((n2 = (int)OS.SendMessage(this.handle, 385, (long)n, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2) {
            this.error(14);
        }
        if (n2 == -1) {
            int n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
            if (n >= 0 && n <= n3) {
                this.error(14);
            } else {
                this.error(6);
            }
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        boolean bl = false;
        switch (n) {
            case 276: 
            case 277: {
                boolean bl2 = bl = this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle);
                if (!bl) break;
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            }
        }
        long l4 = OS.CallWindowProc(ListProc, l, n, l2, l3);
        switch (n) {
            case 276: 
            case 277: {
                if (!bl) break;
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return l4;
    }

    static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if (n == -1) {
            if ((this.style & 0x100) != 0) {
                n4 = (int)OS.SendMessage(this.handle, 403, 0L, 0L);
                n4 -= 3;
            } else {
                n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
                long l = 0L;
                long l2 = OS.GetDC(this.handle);
                long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
                if (l3 != 0L) {
                    l = OS.SelectObject(l2, l3);
                }
                RECT rECT = new RECT();
                int n6 = 3104;
                int n7 = this.getCodePage();
                TCHAR tCHAR = new TCHAR(n7, 65);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = (int)OS.SendMessage(this.handle, 394, (long)n8, 0L);
                    if (n9 != -1) {
                        int n10;
                        if (n9 + 1 > tCHAR.length()) {
                            tCHAR = new TCHAR(n7, n9 + 1);
                        }
                        if ((n10 = (int)OS.SendMessage(this.handle, 393, (long)n8, tCHAR)) != -1) {
                            OS.DrawText(l2, tCHAR, n9, rECT, n6);
                            n4 = Math.max(n4, rECT.right - rECT.left);
                        }
                    }
                    ++n8;
                }
                if (l3 != 0L) {
                    OS.SelectObject(l2, l);
                }
                OS.ReleaseDC(this.handle, l2);
            }
        }
        if (n2 == -1) {
            n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
            int n11 = (int)OS.SendMessage(this.handle, 417, 0L, 0L);
            n5 = n3 * n11;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n5 = n2;
        }
        n3 = this.getBorderWidth();
        n4 += n3 * 2 + 3;
        n5 += n3 * 2;
        if ((this.style & 0x200) != 0) {
            n4 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n5 += OS.GetSystemMetrics(3);
        }
        return new Point(n4, n5);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n = (int)OS.SendMessage(this.handle, 392, 0L, 0L);
            if (n == -1) {
                return;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n == nArray[n2]) {
                    OS.SendMessage(this.handle, 390, -1L, 0L);
                    return;
                }
                ++n2;
            }
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            int n3 = nArray[n];
            if (n3 != -1) {
                OS.SendMessage(this.handle, 389, 0L, (long)n3);
            }
            ++n;
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n == -1) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n2 = (int)OS.SendMessage(this.handle, 392, 0L, 0L);
            if (n2 == -1) {
                return;
            }
            if (n2 == n) {
                OS.SendMessage(this.handle, 390, -1L, 0L);
            }
            return;
        }
        OS.SendMessage(this.handle, 389, 0L, (long)n);
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n3 = (int)OS.SendMessage(this.handle, 392, 0L, 0L);
            if (n3 == -1) {
                return;
            }
            if (n <= n3 && n3 <= n2) {
                OS.SendMessage(this.handle, 390, -1L, 0L);
            }
            return;
        }
        int n4 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n < 0 && n2 < 0) {
            return;
        }
        if (n >= n4 && n2 >= n4) {
            return;
        }
        n = Math.min(n4 - 1, Math.max(0, n));
        n2 = Math.min(n4 - 1, Math.max(0, n2));
        OS.SendMessage(this.handle, 387, (long)n2, (long)n);
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.SendMessage(this.handle, 390, -1L, 0L);
        } else {
            OS.SendMessage(this.handle, 389, 0L, -1L);
        }
    }

    public int getFocusIndex() {
        int n;
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 415, 0L, 0L);
        if (n2 == 0 && (n = (int)OS.SendMessage(this.handle, 395, 0L, 0L)) == 0) {
            return -1;
        }
        return n2;
    }

    public String getItem(int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        int n3 = (int)OS.SendMessage(this.handle, 394, (long)n, 0L);
        if (n3 != -1 && (n2 = (int)OS.SendMessage(this.handle, 393, (long)n, tCHAR = new TCHAR(this.getCodePage(), n3 + 1))) != -1) {
            return tCHAR.toString(0, n3);
        }
        int n4 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n >= 0 && n < n4) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 417, 0L, 0L);
        if (n == -1) {
            this.error(11);
        }
        return n;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = this.getSelectionIndices();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getItem(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = (int)OS.SendMessage(this.handle, 392, 0L, 0L);
            if (n == -1) {
                return 0;
            }
            return 1;
        }
        int n = (int)OS.SendMessage(this.handle, 400, 0L, 0L);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return (int)OS.SendMessage(this.handle, 392, 0L, 0L);
        }
        int n = (int)OS.SendMessage(this.handle, 400, 0L, 0L);
        if (n == -1) {
            this.error(9);
        }
        if (n == 0) {
            return -1;
        }
        int n2 = (int)OS.SendMessage(this.handle, 415, 0L, 0L);
        int n3 = (int)OS.SendMessage(this.handle, 391, (long)n2, 0L);
        if (n3 == -1) {
            this.error(9);
        }
        if (n3 != 0) {
            return n2;
        }
        int[] nArray = new int[1];
        n3 = (int)OS.SendMessage(this.handle, 401, 1L, nArray);
        if (n3 != 1) {
            this.error(9);
        }
        return nArray[0];
    }

    public int[] getSelectionIndices() {
        int[] nArray;
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n2 = (int)OS.SendMessage(this.handle, 392, 0L, 0L);
            if (n2 == -1) {
                return new int[0];
            }
            return new int[]{n2};
        }
        int n3 = (int)OS.SendMessage(this.handle, 400, 0L, 0L);
        if (n3 == -1) {
            this.error(9);
        }
        if ((n = (int)OS.SendMessage(this.handle, 401, (long)n3, nArray = new int[n3])) != n3) {
            this.error(9);
        }
        return nArray;
    }

    public int getTopIndex() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 398, 0L, 0L);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n2 = this.getItemCount();
            int n3 = n;
            while (n3 < n2) {
                if (string.equals(this.getItem(n3))) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        int n4 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n < 0 || n >= n4) {
            return -1;
        }
        int n5 = n - 1;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            int n6;
            if ((n5 = (int)OS.SendMessage(this.handle, 418, (long)(n6 = n5), tCHAR)) != -1 && n5 > n6) continue;
            return -1;
        } while (!string.equals(this.getItem(n5)));
        return n5;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 391, (long)n, 0L);
        return n2 != 0 && n2 != -1;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = (int)OS.SendMessage(this.handle, 398, 0L, 0L);
        RECT rECT = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            l = OS.GetDC(this.handle);
            l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l3 != 0L) {
                l2 = OS.SelectObject(l, l3);
            }
        }
        int n6 = this.getCodePage();
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        while (n7 < nArray2.length) {
            int n10 = nArray2[n7];
            if (n10 != n9) {
                int n11;
                int n12;
                TCHAR tCHAR = null;
                if ((this.style & 0x100) != 0 && ((n12 = (int)OS.SendMessage(this.handle, 394, (long)n10, 0L)) == -1 || (n11 = (int)OS.SendMessage(this.handle, 393, (long)n10, tCHAR = new TCHAR(n6, n12 + 1))) == -1) || (n12 = (int)OS.SendMessage(this.handle, 386, (long)n10, 0L)) == -1) break;
                if ((this.style & 0x100) != 0) {
                    n11 = 3104;
                    OS.DrawText(l, tCHAR, -1, rECT, n11);
                    n5 = Math.max(n5, rECT.right - rECT.left);
                }
                if (n10 < n4) {
                    ++n8;
                }
                n9 = n10;
            }
            ++n7;
        }
        if ((this.style & 0x100) != 0) {
            if (l3 != 0L) {
                OS.SelectObject(l, l2);
            }
            OS.ReleaseDC(this.handle, l);
            this.setScrollWidth(n5, false);
        }
        if (n8 > 0) {
            OS.SendMessage(this.handle, 407, (long)(n4 -= n8), 0L);
        }
        if (n7 < nArray2.length) {
            this.error(15);
        }
    }

    public void remove(int n) {
        int n2;
        int n3;
        int n4;
        this.checkWidget();
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n4 = (int)OS.SendMessage(this.handle, 394, (long)n, 0L);
            if (n4 == -1) {
                n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
                if (n >= 0 && n < n3) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n3 = (int)OS.SendMessage(this.handle, 393, (long)n, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) == -1) {
                n2 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
                if (n >= 0 && n < n2) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n4 = (int)OS.SendMessage(this.handle, 398, 0L, 0L);
        n3 = (int)OS.SendMessage(this.handle, 386, (long)n, 0L);
        if (n3 == -1) {
            n2 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
            if (n >= 0 && n < n2) {
                this.error(15);
            }
            this.error(6);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, false);
        }
        if (n < n4) {
            OS.SendMessage(this.handle, 407, (long)(n4 - 1), 0L);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        if (n == 0 && n2 == n3 - 1) {
            this.removeAll();
            return;
        }
        int n4 = (int)OS.SendMessage(this.handle, 398, 0L, 0L);
        RECT rECT = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            l = OS.GetDC(this.handle);
            l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l3 != 0L) {
                l2 = OS.SelectObject(l, l3);
            }
        }
        int n6 = this.getCodePage();
        int n7 = n;
        int n8 = 3104;
        while (n7 <= n2) {
            int n9;
            int n10;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n10 = (int)OS.SendMessage(this.handle, 394, (long)n, 0L)) == -1 || (n9 = (int)OS.SendMessage(this.handle, 393, (long)n, tCHAR = new TCHAR(n6, n10 + 1))) == -1) || (n10 = (int)OS.SendMessage(this.handle, 386, (long)n, 0L)) == -1) break;
            if ((this.style & 0x100) != 0) {
                OS.DrawText(l, tCHAR, -1, rECT, n8);
                n5 = Math.max(n5, rECT.right - rECT.left);
            }
            ++n7;
        }
        if ((this.style & 0x100) != 0) {
            if (l3 != 0L) {
                OS.SelectObject(l, l2);
            }
            OS.ReleaseDC(this.handle, l);
            this.setScrollWidth(n5, false);
        }
        if (n2 < n4) {
            OS.SendMessage(this.handle, 407, (long)(n4 -= n2 - n + 1), 0L);
        }
        if (n7 <= n2) {
            this.error(15);
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 388, 0L, 0L);
        if ((this.style & 0x100) != 0) {
            OS.SendMessage(this.handle, 404, 0L, 0L);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.select(nArray, false);
    }

    void select(int[] nArray, boolean bl) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 != -1) {
                this.select(n2, false);
            }
            ++n;
        }
        if (bl) {
            this.showSelection();
        }
    }

    public void select(int n) {
        this.checkWidget();
        this.select(n, false);
    }

    void select(int n, boolean bl) {
        boolean bl2;
        if (n < 0) {
            return;
        }
        int n2 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n >= n2) {
            return;
        }
        if (bl) {
            if ((this.style & 4) != 0) {
                OS.SendMessage(this.handle, 390, (long)n, 0L);
            } else {
                OS.SendMessage(this.handle, 389, 1L, (long)n);
            }
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 398, 0L, 0L);
        RECT rECT = new RECT();
        RECT rECT2 = null;
        OS.SendMessage(this.handle, 408, (long)n, rECT);
        boolean bl3 = bl2 = this.getDrawing() && OS.IsWindowVisible(this.handle);
        if (bl2) {
            OS.UpdateWindow(this.handle);
            OS.SendMessage(this.handle, 11, 0L, 0L);
        }
        int n4 = -1;
        if ((this.style & 4) != 0) {
            int n5 = (int)OS.SendMessage(this.handle, 392, 0L, 0L);
            if (n5 != -1) {
                rECT2 = new RECT();
                OS.SendMessage(this.handle, 408, (long)n5, rECT2);
            }
            OS.SendMessage(this.handle, 390, (long)n, 0L);
        } else {
            n4 = (int)OS.SendMessage(this.handle, 415, 0L, 0L);
            OS.SendMessage(this.handle, 389, 1L, (long)n);
        }
        if ((this.style & 2) != 0 && n4 != -1) {
            OS.SendMessage(this.handle, 414, (long)n4, 0L);
        }
        OS.SendMessage(this.handle, 407, (long)n3, 0L);
        if (bl2) {
            OS.SendMessage(this.handle, 11, 1L, 0L);
            OS.ValidateRect(this.handle, null);
            OS.InvalidateRect(this.handle, rECT, true);
            if (rECT2 != null) {
                OS.InvalidateRect(this.handle, rECT2, true);
            }
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if ((this.style & 4) != 0) {
            this.select(n, false);
        } else {
            this.select(n, n2, false);
        }
    }

    void select(int n, int n2, boolean bl) {
        if (n == n2) {
            this.select(n, bl);
            return;
        }
        OS.SendMessage(this.handle, 387, (long)n, (long)n2);
        if (bl) {
            this.showSelection();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 389, 1L, -1L);
    }

    void setFocusIndex(int n) {
        int n2 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n < 0 || n >= n2) {
            return;
        }
        OS.SendMessage(this.handle, 414, (long)n, 0L);
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getTopIndex();
        boolean bl = this.isSelected(n);
        this.remove(n);
        this.add(string, n);
        if (bl) {
            this.select(n, false);
        }
        this.setTopIndex(n2);
    }

    public void setItems(String[] stringArray) {
        boolean bl;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        long l = OS.GetWindowLongPtr(this.handle, -4);
        OS.SetWindowLongPtr(this.handle, -4, ListProc);
        boolean bl2 = bl = this.getDrawing() && OS.IsWindowVisible(this.handle);
        if (bl) {
            OS.SendMessage(this.handle, 11, 0L, 0L);
        }
        RECT rECT = null;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n2 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            l2 = OS.GetDC(this.handle);
            l4 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l4 != 0L) {
                l3 = OS.SelectObject(l2, l4);
            }
            OS.SendMessage(this.handle, 404, 0L, 0L);
        }
        int n3 = stringArray.length;
        OS.SendMessage(this.handle, 388, 0L, 0L);
        OS.SendMessage(this.handle, 424, (long)n3, (long)(n3 * 32));
        int n4 = 0;
        int n5 = this.getCodePage();
        while (n4 < n3) {
            String string = stringArray[n4];
            TCHAR tCHAR = new TCHAR(n5, string, true);
            int n6 = (int)OS.SendMessage(this.handle, 384, 0L, tCHAR);
            if (n6 == -1 || n6 == -2) break;
            if ((this.style & 0x100) != 0) {
                int n7 = 3104;
                OS.DrawText(l2, tCHAR, -1, rECT, n7);
                n2 = Math.max(n2, rECT.right - rECT.left);
            }
            ++n4;
        }
        if ((this.style & 0x100) != 0) {
            if (l4 != 0L) {
                OS.SelectObject(l2, l3);
            }
            OS.ReleaseDC(this.handle, l2);
            OS.SendMessage(this.handle, 404, (long)(n2 + 3), 0L);
        }
        if (bl) {
            OS.SendMessage(this.handle, 11, 1L, 0L);
        }
        OS.SetWindowLongPtr(this.handle, -4, l);
        if (n4 < stringArray.length) {
            this.error(14);
        }
    }

    void setScrollWidth() {
        int n = 0;
        RECT rECT = new RECT();
        long l = 0L;
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l3 != 0L) {
            l = OS.SelectObject(l2, l3);
        }
        int n2 = this.getCodePage();
        int n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        int n4 = 3104;
        int n5 = 0;
        while (n5 < n3) {
            TCHAR tCHAR;
            int n6;
            int n7 = (int)OS.SendMessage(this.handle, 394, (long)n5, 0L);
            if (n7 != -1 && (n6 = (int)OS.SendMessage(this.handle, 393, (long)n5, tCHAR = new TCHAR(n2, n7 + 1))) != -1) {
                OS.DrawText(l2, tCHAR, -1, rECT, n4);
                n = Math.max(n, rECT.right - rECT.left);
            }
            ++n5;
        }
        if (l3 != 0L) {
            OS.SelectObject(l2, l);
        }
        OS.ReleaseDC(this.handle, l2);
        OS.SendMessage(this.handle, 404, (long)(n + 3), 0L);
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl) {
        RECT rECT = new RECT();
        long l = 0L;
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
        if (l3 != 0L) {
            l = OS.SelectObject(l2, l3);
        }
        int n = 3104;
        OS.DrawText(l2, tCHAR, -1, rECT, n);
        if (l3 != 0L) {
            OS.SelectObject(l2, l);
        }
        OS.ReleaseDC(this.handle, l2);
        this.setScrollWidth(rECT.right - rECT.left, bl);
    }

    void setScrollWidth(int n, boolean bl) {
        n += 3;
        int n2 = (int)OS.SendMessage(this.handle, 403, 0L, 0L);
        if (bl) {
            if (n <= n2) {
                return;
            }
            OS.SendMessage(this.handle, 404, (long)n, 0L);
        } else {
            if (n < n2) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray, true);
        if ((this.style & 2) != 0 && (n = nArray[0]) >= 0) {
            this.setFocusIndex(n);
        }
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = stringArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = -1;
        int n3 = n - 1;
        while (n3 >= 0) {
            String string = stringArray[n3];
            int n4 = 0;
            if (string != null) {
                int n5 = -1;
                while ((n4 = this.indexOf(string, n4)) != -1) {
                    if (n5 == -1) {
                        n5 = n4;
                    }
                    this.select(n4, false);
                    if ((this.style & 4) != 0 && this.isSelected(n4)) {
                        this.showSelection();
                        return;
                    }
                    ++n4;
                }
                if (n5 != -1) {
                    n2 = n5;
                }
            }
            --n3;
        }
        if ((this.style & 2) != 0 && n2 >= 0) {
            this.setFocusIndex(n2);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.select(n, true);
        if ((this.style & 2) != 0 && n >= 0) {
            this.setFocusIndex(n);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if ((this.style & 4) != 0) {
            this.select(n, true);
        } else {
            this.select(n, n2, true);
            this.setFocusIndex(n);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 407, (long)n, 0L);
        if (n2 == -1) {
            int n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
            n = Math.min(n3 - 1, Math.max(0, n));
            OS.SendMessage(this.handle, 407, (long)n, 0L);
        }
    }

    public void showSelection() {
        int n;
        int n2;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            n2 = (int)OS.SendMessage(this.handle, 392, 0L, 0L);
        } else {
            int[] nArray = new int[1];
            n = (int)OS.SendMessage(this.handle, 401, 1L, nArray);
            n2 = nArray[0];
            if (n != 1) {
                n2 = -1;
            }
        }
        if (n2 == -1) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
        if (n3 == 0) {
            return;
        }
        n = (int)OS.SendMessage(this.handle, 417, 0L, 0L);
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n4 = (int)OS.SendMessage(this.handle, 398, 0L, 0L);
        int n5 = Math.max(rECT.bottom / n, 1);
        int n6 = Math.min(n4 + n5, n3) - 1;
        if (n4 <= n2 && n2 <= n6) {
            return;
        }
        int n7 = Math.min(Math.max(n2 - n5 / 2, 0), n3 - 1);
        OS.SendMessage(this.handle, 407, (long)n7, 0L);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 1 | 0x100;
        if ((this.style & 4) != 0) {
            return n;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x40) != 0) {
                return n | 8;
            }
            return n | 0x800;
        }
        return n;
    }

    TCHAR windowClass() {
        return ListClass;
    }

    long windowProc() {
        return ListProc;
    }

    LRESULT WM_CHAR(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_CHAR(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetKeyState(17) < 0 && OS.GetKeyState(16) >= 0 && ((n = OS.GetWindowLong(this.handle, -16)) & 0x800) != 0) {
            switch ((int)l) {
                case 32: {
                    int n2 = (int)OS.SendMessage(this.handle, 415, 0L, 0L);
                    int n3 = (int)OS.SendMessage(this.handle, 391, (long)n2, 0L);
                    if (n3 == -1) break;
                    OS.SendMessage(this.handle, 389, (long)(n3 != 0 ? 0 : 1), (long)n2);
                    OS.SendMessage(this.handle, 61852, (long)n2, 0L);
                    this.postEvent(13);
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_KEYDOWN(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_KEYDOWN(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetKeyState(17) < 0 && OS.GetKeyState(16) >= 0 && ((n = OS.GetWindowLong(this.handle, -16)) & 0x800) != 0) {
            int n2;
            int n3 = -1;
            switch ((int)l) {
                case 32: {
                    return LRESULT.ZERO;
                }
                case 38: 
                case 40: {
                    n2 = (int)OS.SendMessage(this.handle, 415, 0L, 0L);
                    n3 = Math.max(0, n2 + ((int)l == 38 ? -1 : 1));
                    break;
                }
                case 33: {
                    n2 = (int)OS.SendMessage(this.handle, 398, 0L, 0L);
                    int n4 = (int)OS.SendMessage(this.handle, 415, 0L, 0L);
                    if (n4 != n2) {
                        n3 = n2;
                        break;
                    }
                    this.forceResize();
                    RECT rECT = new RECT();
                    OS.GetClientRect(this.handle, rECT);
                    int n5 = (int)OS.SendMessage(this.handle, 417, 0L, 0L);
                    int n6 = Math.max(2, rECT.bottom / n5);
                    n3 = Math.max(0, n2 - (n6 - 1));
                    break;
                }
                case 34: {
                    n2 = (int)OS.SendMessage(this.handle, 398, 0L, 0L);
                    int n4 = (int)OS.SendMessage(this.handle, 415, 0L, 0L);
                    this.forceResize();
                    RECT rECT = new RECT();
                    OS.GetClientRect(this.handle, rECT);
                    int n7 = (int)OS.SendMessage(this.handle, 417, 0L, 0L);
                    int n8 = Math.max(2, rECT.bottom / n7);
                    int n9 = n2 + n8 - 1;
                    n3 = n4 != n9 ? n9 : n9 + n8 - 1;
                    int n10 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
                    if (n10 == -1) break;
                    n3 = Math.min(n10 - 1, n3);
                    break;
                }
                case 36: {
                    n3 = 0;
                    break;
                }
                case 35: {
                    n2 = (int)OS.SendMessage(this.handle, 395, 0L, 0L);
                    if (n2 == -1) break;
                    n3 = n2 - 1;
                }
            }
            if (n3 != -1) {
                n2 = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
                if ((n2 & 1) != 0) {
                    OS.SendMessage(this.handle, 295, 3L, 0L);
                    RECT rECT = new RECT();
                    int n11 = (int)OS.SendMessage(this.handle, 415, 0L, 0L);
                    OS.SendMessage(this.handle, 408, (long)n11, rECT);
                    OS.InvalidateRect(this.handle, rECT, true);
                }
                OS.SendMessage(this.handle, 414, (long)n3, 0L);
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_SETREDRAW(long l, long l2) {
        LRESULT lRESULT = super.WM_SETREDRAW(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        OS.DefWindowProc(this.handle, 11, l, l2);
        return lRESULT;
    }

    LRESULT WM_SIZE(long l, long l2) {
        int n = (int)OS.SendMessage(this.handle, 398, 0L, 0L);
        LRESULT lRESULT = super.WM_SIZE(l, l2);
        if (!this.isDisposed()) {
            int n2;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            if (OS.GetScrollInfo(this.handle, 0, sCROLLINFO) && sCROLLINFO.nPos != 0) {
                OS.InvalidateRect(this.handle, null, true);
            }
            if (n != (n2 = (int)OS.SendMessage(this.handle, 398, 0L, 0L))) {
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(long l, long l2) {
        int n = OS.HIWORD(l);
        switch (n) {
            case 1: {
                this.postEvent(13);
                break;
            }
            case 2: {
                this.postEvent(14);
            }
        }
        return super.wmCommandChild(l, l2);
    }
}

