/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.MethodData;
import com.android.traceview.ProfileData;
import com.android.traceview.ProfileNode;
import com.android.traceview.ProfileProvider;
import com.android.traceview.Selection;
import com.android.traceview.SelectionController;
import com.android.traceview.TraceReader;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProfileView
extends Composite
implements Observer {
    private TreeViewer mTreeViewer;
    private Text mSearchBox;
    private SelectionController mSelectionController;
    private ProfileProvider mProfileProvider;
    private Color mColorNoMatch;
    private Color mColorMatch;
    private MethodData mCurrentHighlightedMethod;
    private MethodHandler mMethodHandler;

    public ProfileView(Composite parent, TraceReader reader, SelectionController selectController) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        this.mSelectionController = selectController;
        this.mSelectionController.addObserver(this);
        this.mTreeViewer = new TreeViewer((Composite)this, 2);
        this.mTreeViewer.setUseHashlookup(true);
        this.mProfileProvider = reader.getProfileProvider();
        this.mProfileProvider.setTreeViewer(this.mTreeViewer);
        SelectionAdapter listener = this.mProfileProvider.getColumnListener();
        final Tree tree = this.mTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(1808));
        String[] columnNames = this.mProfileProvider.getColumnNames();
        int[] columnWidths = this.mProfileProvider.getColumnWidths();
        int[] columnAlignments = this.mProfileProvider.getColumnAlignments();
        for (int ii = 0; ii < columnWidths.length; ++ii) {
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(columnNames[ii]);
            column.setWidth(columnWidths[ii]);
            column.setMoveable(true);
            column.addSelectionListener((SelectionListener)listener);
            column.setAlignment(columnAlignments[ii]);
        }
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                int fontHeight;
                event.height = fontHeight = event.gc.getFontMetrics().getHeight();
            }
        });
        this.mTreeViewer.setContentProvider((IContentProvider)this.mProfileProvider);
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)this.mProfileProvider.getLabelProvider());
        this.mTreeViewer.setInput(this.mProfileProvider.getRoot());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText("Find:");
        this.mSearchBox = new Text(composite, 2048);
        this.mSearchBox.setLayoutData((Object)new GridData(768));
        Display display = this.getDisplay();
        this.mColorNoMatch = new Color((Device)display, 255, 200, 200);
        this.mColorMatch = this.mSearchBox.getBackground();
        this.mSearchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                String query = ProfileView.this.mSearchBox.getText();
                if (query.length() == 0) {
                    return;
                }
                ProfileView.this.findName(query);
            }
        });
        this.mSearchBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 27) {
                    ProfileView.this.mSearchBox.setText("");
                } else if (event.keyCode == 13) {
                    String query = ProfileView.this.mSearchBox.getText();
                    if (query.length() == 0) {
                        return;
                    }
                    ProfileView.this.findNextName(query);
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 27) {
                    ProfileView.this.mSearchBox.setText("");
                } else if (event.keyCode == 8) {
                    String text = ProfileView.this.mSearchBox.getText();
                    int len = text.length();
                    String chopped = len <= 1 ? "" : text.substring(0, len - 1);
                    ProfileView.this.mSearchBox.setText(chopped);
                } else if (event.keyCode == 13) {
                    String query = ProfileView.this.mSearchBox.getText();
                    if (query.length() == 0) {
                        return;
                    }
                    ProfileView.this.findNextName(query);
                } else {
                    String str = String.valueOf(event.character);
                    ProfileView.this.mSearchBox.append(str);
                }
                event.doit = false;
            }
        });
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent ev) {
                ISelection sel = ev.getSelection();
                if (sel.isEmpty()) {
                    return;
                }
                if (sel instanceof IStructuredSelection) {
                    MethodData md;
                    IStructuredSelection selection = (IStructuredSelection)sel;
                    Object element = selection.getFirstElement();
                    if (element == null) {
                        return;
                    }
                    if (element instanceof MethodData) {
                        md = (MethodData)element;
                        ProfileView.this.highlightMethod(md, true);
                    }
                    if (element instanceof ProfileData) {
                        md = ((ProfileData)element).getMethodData();
                        ProfileView.this.highlightMethod(md, true);
                    }
                }
            }
        });
        this.mTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                Object element = event.getElement();
                if (element instanceof MethodData) {
                    MethodData md = (MethodData)element;
                    ProfileView.this.expandNode(md);
                }
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        tree.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem treeItem = tree.getItem(point);
                MethodData md = ProfileView.this.mProfileProvider.findMatchingTreeItem(treeItem);
                if (md == null) {
                    return;
                }
                ArrayList<Selection> selections = new ArrayList<Selection>();
                selections.add(Selection.highlight("MethodData", md));
                ProfileView.this.mSelectionController.change(selections, "ProfileView");
                if (ProfileView.this.mMethodHandler != null && (event.stateMask & SWT.MOD1) != 0) {
                    ProfileView.this.mMethodHandler.handleMethod(md);
                }
            }
        });
    }

    public void setMethodHandler(MethodHandler handler) {
        this.mMethodHandler = handler;
    }

    private void findName(String query) {
        MethodData md = this.mProfileProvider.findMatchingName(query);
        this.selectMethod(md);
    }

    private void findNextName(String query) {
        MethodData md = this.mProfileProvider.findNextMatchingName(query);
        this.selectMethod(md);
    }

    private void selectMethod(MethodData md) {
        if (md == null) {
            this.mSearchBox.setBackground(this.mColorNoMatch);
            return;
        }
        this.mSearchBox.setBackground(this.mColorMatch);
        this.highlightMethod(md, false);
    }

    @Override
    public void update(Observable objservable, Object arg) {
        if (arg == "ProfileView") {
            return;
        }
        ArrayList<Selection> selections = this.mSelectionController.getSelections();
        for (Selection selection : selections) {
            Selection.Action action = selection.getAction();
            if (action != Selection.Action.Highlight) continue;
            String name = selection.getName();
            if (name == "MethodData") {
                MethodData md = (MethodData)selection.getValue();
                this.highlightMethod(md, true);
                return;
            }
            if (name != "Call") continue;
            Call call = (Call)selection.getValue();
            MethodData md = call.getMethodData();
            this.highlightMethod(md, true);
            return;
        }
    }

    private void highlightMethod(MethodData md, boolean clearSearch) {
        if (md == null) {
            return;
        }
        if (md == this.mCurrentHighlightedMethod) {
            return;
        }
        if (clearSearch) {
            this.mSearchBox.setText("");
            this.mSearchBox.setBackground(this.mColorMatch);
        }
        this.mCurrentHighlightedMethod = md;
        this.mTreeViewer.collapseAll();
        this.expandNode(md);
        StructuredSelection sel = new StructuredSelection((Object)md);
        this.mTreeViewer.setSelection((ISelection)sel, true);
        Tree tree = this.mTreeViewer.getTree();
        TreeItem[] items = tree.getSelection();
        if (items.length != 0) {
            tree.setTopItem(items[0]);
            tree.showItem(items[0]);
        }
    }

    private void expandNode(MethodData md) {
        ProfileNode[] nodes = md.getProfileNodes();
        this.mTreeViewer.setExpandedState((Object)md, true);
        if (nodes != null) {
            for (ProfileNode node : nodes) {
                if (node.isRecursive()) continue;
                this.mTreeViewer.setExpandedState((Object)node, true);
            }
        }
    }

    public static interface MethodHandler {
        public void handleMethod(MethodData var1);
    }
}

