/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.configuration;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.Locale;

public final class LocaleQualifier
extends ResourceQualifier {
    public static final String FAKE_VALUE = "__";
    public static final String NAME = "Locale";
    public static final String BCP_47_PREFIX = "b+";
    private static final String CAR_DOCK_MODE = "car";
    private String mFull;
    private String mLanguage;
    private String mRegion;
    private String mScript;

    public LocaleQualifier() {
        this.mFull = "";
    }

    public LocaleQualifier(String language) {
        assert (language.length() == 2 || language.length() == 3);
        this.mLanguage = language;
        this.mFull = language;
    }

    public LocaleQualifier(String full, String language, String region, String script) {
        if (full == null) {
            if (region != null && region.length() == 3 || script != null) {
                StringBuilder sb = new StringBuilder(BCP_47_PREFIX);
                sb.append(language);
                if (region != null) {
                    sb.append('+');
                    sb.append(region);
                }
                if (script != null) {
                    sb.append('+');
                    sb.append(script);
                }
                full = sb.toString();
            } else {
                full = region != null ? language + "-r" + region : language;
            }
        }
        this.mFull = full;
        this.mLanguage = language;
        this.mRegion = region;
        this.mScript = script;
    }

    public static boolean isRegionSegment(String segment) {
        return (segment.startsWith("r") || segment.startsWith("R")) && segment.length() == 3 && Character.isLetter(segment.charAt(0)) && Character.isLetter(segment.charAt(1));
    }

    private static boolean isValidAlpha2Code(String str) {
        return str.length() == 2 && CharMatcher.JAVA_LETTER.matchesAllOf((CharSequence)str);
    }

    private static boolean isValidAlpha3Code(String str) {
        return str.length() == 3 && CharMatcher.JAVA_LETTER.matchesAllOf((CharSequence)str);
    }

    private static boolean isValidM49Code(String str) {
        return str.length() == 3 && Character.isDigit(str.charAt(0)) && Character.isDigit(str.charAt(1)) && Character.isDigit(str.charAt(2));
    }

    public static LocaleQualifier getQualifier(String segment) {
        if (CAR_DOCK_MODE.equals(segment.toLowerCase(Locale.US))) {
            return null;
        }
        if (segment.startsWith(BCP_47_PREFIX)) {
            return LocaleQualifier.parseBcp47(segment);
        }
        String[] components = segment.split("-");
        if (components.length > 2) {
            return null;
        }
        String language = components[0].toLowerCase(Locale.US);
        if (!LocaleQualifier.isValidAlpha2Code(language) && !LocaleQualifier.isValidAlpha3Code(language)) {
            return null;
        }
        String region = null;
        if (components.length > 1) {
            if (components[1].length() < 1 || Character.toLowerCase(components[1].charAt(0)) != 'r') {
                return null;
            }
            region = components[1].substring(1);
            if (!LocaleQualifier.isValidAlpha2Code(region) && !LocaleQualifier.isValidM49Code(region)) {
                return null;
            }
        }
        if (region == null) {
            return new LocaleQualifier(language, language, null, null);
        }
        return new LocaleQualifier(language + "-r" + region, language, region, null);
    }

    public static String normalizeCase(String segment) {
        if (LocaleQualifier.isNormalizedCase(segment)) {
            return segment;
        }
        StringBuilder sb = new StringBuilder(segment.length());
        if (segment.startsWith(BCP_47_PREFIX)) {
            sb.append(BCP_47_PREFIX);
            assert (segment.startsWith(BCP_47_PREFIX));
            int segmentBegin = BCP_47_PREFIX.length();
            int segmentLength = segment.length();
            int start = segmentBegin;
            int lastLength = -1;
            while (start < segmentLength) {
                int i;
                int length;
                int end;
                if (start != segmentBegin) {
                    sb.append('+');
                }
                if ((end = segment.indexOf(43, start)) == -1) {
                    end = segmentLength;
                }
                if ((length = end - start) != 2 && length != 4 || start == segmentBegin || lastLength == 1) {
                    for (i = start; i < end; ++i) {
                        sb.append(Character.toLowerCase(segment.charAt(i)));
                    }
                } else if (length == 2) {
                    for (i = start; i < end; ++i) {
                        sb.append(Character.toUpperCase(segment.charAt(i)));
                    }
                } else {
                    assert (length == 4) : length;
                    sb.append(Character.toUpperCase(segment.charAt(start)));
                    for (i = start + 1; i < end; ++i) {
                        sb.append(Character.toLowerCase(segment.charAt(i)));
                    }
                }
                lastLength = length;
                start = end + 1;
            }
        } else if (segment.length() == 6) {
            sb.append(Character.toLowerCase(segment.charAt(0)));
            sb.append(Character.toLowerCase(segment.charAt(1)));
            sb.append(segment.charAt(2));
            sb.append(Character.toLowerCase(segment.charAt(3)));
            sb.append(Character.toUpperCase(segment.charAt(4)));
            sb.append(Character.toUpperCase(segment.charAt(5)));
        } else if (segment.length() == 7) {
            sb.append(Character.toLowerCase(segment.charAt(0)));
            sb.append(Character.toLowerCase(segment.charAt(1)));
            sb.append(Character.toLowerCase(segment.charAt(2)));
            sb.append(segment.charAt(3));
            sb.append(Character.toLowerCase(segment.charAt(4)));
            sb.append(Character.toUpperCase(segment.charAt(5)));
            sb.append(Character.toUpperCase(segment.charAt(6)));
        } else {
            sb.append(segment.toLowerCase(Locale.US));
        }
        return sb.toString();
    }

    static boolean isNormalizedCase(String segment) {
        if (segment.startsWith(BCP_47_PREFIX)) {
            assert (segment.startsWith(BCP_47_PREFIX));
            int segmentBegin = BCP_47_PREFIX.length();
            int segmentLength = segment.length();
            int start = segmentBegin;
            int lastLength = -1;
            while (start < segmentLength) {
                int length;
                int end = segment.indexOf(43, start);
                if (end == -1) {
                    end = segmentLength;
                }
                if ((length = end - start) != 2 && length != 4 || start == segmentBegin || lastLength == 1) {
                    if (LocaleQualifier.isNotLowerCase(segment, start, end)) {
                        return false;
                    }
                } else if (length == 2) {
                    if (LocaleQualifier.isNotUpperCase(segment, start, end)) {
                        return false;
                    }
                } else {
                    assert (length == 4) : length;
                    if (LocaleQualifier.isNotUpperCase(segment, start, start + 1)) {
                        return false;
                    }
                    if (LocaleQualifier.isNotLowerCase(segment, start + 1, end)) {
                        return false;
                    }
                }
                lastLength = length;
                start = end + 1;
            }
            return true;
        }
        if (segment.length() == 2) {
            return Character.isLowerCase(segment.charAt(0)) && Character.isLowerCase(segment.charAt(1));
        }
        if (segment.length() == 3) {
            return Character.isLowerCase(segment.charAt(0)) && Character.isLowerCase(segment.charAt(1)) && Character.isLowerCase(segment.charAt(2));
        }
        if (segment.length() == 6) {
            return Character.isLowerCase(segment.charAt(0)) && Character.isLowerCase(segment.charAt(1)) && Character.isLowerCase(segment.charAt(3)) && Character.isUpperCase(segment.charAt(4)) && Character.isUpperCase(segment.charAt(5));
        }
        if (segment.length() == 7) {
            return Character.isLowerCase(segment.charAt(0)) && Character.isLowerCase(segment.charAt(1)) && Character.isLowerCase(segment.charAt(2)) && Character.isLowerCase(segment.charAt(4)) && Character.isUpperCase(segment.charAt(5)) && Character.isUpperCase(segment.charAt(6));
        }
        return true;
    }

    private static boolean isNotLowerCase(String segment, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!Character.isUpperCase(segment.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotUpperCase(String segment, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (!Character.isLowerCase(segment.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public String getValue() {
        return this.mFull;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public int since() {
        return 1;
    }

    @Override
    public boolean isValid() {
        return this.mFull != FAKE_VALUE;
    }

    @Override
    public boolean hasFakeValue() {
        return this.mFull == FAKE_VALUE;
    }

    public boolean hasLanguage() {
        return !FAKE_VALUE.equals(this.mLanguage);
    }

    public boolean hasRegion() {
        return this.mRegion != null && !FAKE_VALUE.equals(this.mRegion);
    }

    @Override
    public boolean checkAndSet(String value, FolderConfiguration config) {
        LocaleQualifier qualifier = LocaleQualifier.getQualifier(value);
        if (qualifier != null) {
            config.setLocaleQualifier(qualifier);
            return true;
        }
        return false;
    }

    void setRegionSegment(String segment) {
        assert (segment.length() == 3) : segment;
        this.mRegion = new String(new char[]{Character.toUpperCase(segment.charAt(1)), Character.toUpperCase(segment.charAt(2))});
        this.mFull = this.mLanguage + "-r" + this.mRegion;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocaleQualifier qualifier = (LocaleQualifier)o;
        return this.mFull.equals(qualifier.mFull);
    }

    @Override
    public int hashCode() {
        return this.mFull.hashCode();
    }

    @Override
    public String getFolderSegment() {
        return this.mFull;
    }

    @Override
    public String getShortDisplayValue() {
        if (this.mFull.startsWith(BCP_47_PREFIX)) {
            return this.mFull;
        }
        if (this.mRegion != null) {
            return this.mLanguage + ',' + this.mRegion;
        }
        return this.mLanguage;
    }

    public String getTag() {
        if (this.mFull.startsWith(BCP_47_PREFIX)) {
            return this.mFull.substring(BCP_47_PREFIX.length()).replace('+', '-');
        }
        if (this.mRegion != null) {
            return this.mLanguage + '-' + this.mRegion;
        }
        return this.mLanguage;
    }

    @Override
    public String getLongDisplayValue() {
        if (this.mFull.startsWith(BCP_47_PREFIX)) {
            return String.format("Locale %1$s", this.mFull);
        }
        if (this.mRegion != null) {
            return String.format("Locale %1$s_%2$s", this.mLanguage, this.mRegion);
        }
        if (this.mFull != FAKE_VALUE) {
            return String.format("Locale %1$s", this.mLanguage);
        }
        return "";
    }

    public static LocaleQualifier parseBcp47(String qualifier) {
        if (qualifier.startsWith(BCP_47_PREFIX)) {
            qualifier = LocaleQualifier.normalizeCase(qualifier);
            Iterator iterator = Splitter.on((char)'+').split((CharSequence)qualifier).iterator();
            iterator.next();
            if (iterator.hasNext()) {
                String language = (String)iterator.next();
                String region = null;
                String script = null;
                if (language.length() >= 2 && language.length() <= 3) {
                    if (iterator.hasNext()) {
                        String next = (String)iterator.next();
                        if (next.length() == 4) {
                            script = next;
                            if (iterator.hasNext()) {
                                next = (String)iterator.next();
                            }
                        } else if (next.length() >= 5) {
                            return new LocaleQualifier(qualifier, language, null, null);
                        }
                        if (next.length() >= 2 && next.length() <= 3) {
                            region = next;
                        }
                    }
                    if (!(script != null || region != null && region.length() != 2 || iterator.hasNext())) {
                        qualifier = language.toLowerCase(Locale.US);
                        if (region != null) {
                            qualifier = qualifier + "-r" + region.toUpperCase(Locale.US);
                        }
                    }
                    return new LocaleQualifier(qualifier, language, region, script);
                }
            }
        }
        return null;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public String getRegion() {
        return this.mRegion;
    }

    public String getScript() {
        return this.mScript;
    }

    public String getFull() {
        return this.mFull;
    }

    @Override
    public boolean isMatchFor(ResourceQualifier qualifier) {
        if (qualifier instanceof LocaleQualifier) {
            LocaleQualifier other = (LocaleQualifier)qualifier;
            if (!this.mLanguage.equals(other.mLanguage)) {
                return false;
            }
            if (this.mRegion != null && other.mRegion != null && !this.mRegion.equals(other.mRegion)) {
                return false;
            }
            return this.mScript == null || other.mScript == null || this.mScript.equals(other.mScript);
        }
        return false;
    }
}

