/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.ToggleBreakpointsTargetManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension2;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetManagerListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ToggleBreakpointAction
extends Action
implements IUpdate {
    private IWorkbenchPart fPart;
    private IDocument fDocument;
    private IVerticalRulerInfo fRulerInfo;
    private IToggleBreakpointsTargetManagerListener fListener = new IToggleBreakpointsTargetManagerListener(){

        public void preferredTargetsChanged() {
            ToggleBreakpointAction.this.update();
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ToggleBreakpointAction(IWorkbenchPart part, IDocument document, IVerticalRulerInfo rulerInfo) {
        super(String.valueOf(ActionMessages.ToggleBreakpointAction_0) + '\t' + ActionMessages.ToggleBreakpointAction_3);
        this.fPart = part;
        this.fDocument = document;
        this.fRulerInfo = rulerInfo;
        DebugUITools.getToggleBreakpointsTargetManager().addChangedListener(this.fListener);
    }

    public void run() {
        this.doIt(null);
    }

    public void runWithEvent(Event event) {
        this.doIt(event);
    }

    void doIt(Event event) {
        block17: {
            int line;
            IDocument document = this.getDocument();
            if (document != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
                try {
                    IToggleBreakpointsTargetExtension ext2;
                    IToggleBreakpointsTargetExtension2 ext;
                    ITextSelection selection = this.getTextSelection(document, line);
                    IToggleBreakpointsTarget target = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget(this.fPart, (ISelection)selection);
                    if (target == null) break block17;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension2");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((ext = (IToggleBreakpointsTargetExtension2)DebugPlugin.getAdapter((Object)target, (Class)clazz)) != null && ext.canToggleBreakpointsWithEvent(this.fPart, (ISelection)selection, event)) {
                        ext.toggleBreakpointsWithEvent(this.fPart, (ISelection)selection, event);
                        return;
                    }
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((ext2 = (IToggleBreakpointsTargetExtension)DebugPlugin.getAdapter((Object)target, (Class)clazz2)) != null && ext2.canToggleBreakpoints(this.fPart, (ISelection)selection)) {
                        ext2.toggleBreakpoints(this.fPart, (ISelection)selection);
                        return;
                    }
                    if (target.canToggleLineBreakpoints(this.fPart, (ISelection)selection)) {
                        target.toggleLineBreakpoints(this.fPart, (ISelection)selection);
                    } else if (target.canToggleWatchpoints(this.fPart, (ISelection)selection)) {
                        target.toggleWatchpoints(this.fPart, (ISelection)selection);
                    } else if (target.canToggleMethodBreakpoints(this.fPart, (ISelection)selection)) {
                        target.toggleMethodBreakpoints(this.fPart, (ISelection)selection);
                    }
                }
                catch (BadLocationException ble) {
                    this.reportException((Exception)((Object)ble));
                }
                catch (CoreException ce) {
                    this.reportException((Exception)((Object)ce));
                }
            }
        }
    }

    private void reportException(Exception e) {
        DebugUIPlugin.errorDialog(this.fPart.getSite().getShell(), ActionMessages.ToggleBreakpointAction_1, ActionMessages.ToggleBreakpointAction_2, e);
    }

    public void dispose() {
        this.fDocument = null;
        this.fPart = null;
        this.fRulerInfo = null;
        DebugUITools.getToggleBreakpointsTargetManager().removeChangedListener(this.fListener);
    }

    private IDocument getDocument() {
        IDocument doc;
        ITextEditor editor;
        IDocumentProvider provider;
        if (this.fDocument != null) {
            return this.fDocument;
        }
        if (this.fPart instanceof ITextEditor && (provider = (editor = (ITextEditor)this.fPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((doc = (IDocument)this.fPart.getAdapter((Class)clazz)) != null) {
            return doc;
        }
        return null;
    }

    public void update() {
        int line;
        IDocument document = this.getDocument();
        if (document != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
            try {
                IToggleBreakpointsTargetExtension extension;
                ITextSelection selection = this.getTextSelection(document, line);
                IToggleBreakpointsTarget adapter = ToggleBreakpointsTargetManager.getDefault().getToggleBreakpointsTarget(this.fPart, (ISelection)selection);
                if (adapter == null) {
                    this.setEnabled(false);
                    return;
                }
                if (adapter instanceof IToggleBreakpointsTargetExtension && (extension = (IToggleBreakpointsTargetExtension)adapter).canToggleBreakpoints(this.fPart, (ISelection)selection)) {
                    this.setEnabled(true);
                    return;
                }
                if (adapter.canToggleLineBreakpoints(this.fPart, (ISelection)selection) || adapter.canToggleWatchpoints(this.fPart, (ISelection)selection) || adapter.canToggleMethodBreakpoints(this.fPart, (ISelection)selection)) {
                    this.setEnabled(true);
                    return;
                }
            }
            catch (BadLocationException e) {
                this.reportException((Exception)((Object)e));
            }
        }
        this.setEnabled(false);
    }

    private ITextSelection getTextSelection(IDocument document, int line) throws BadLocationException {
        ISelection selection;
        IRegion region = document.getLineInformation(line);
        TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }
}

