/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;

public class WordlistLoader {
    public static HashMap getWordtable(String path, String wordfile) {
        if (path == null || wordfile == null) {
            return new HashMap();
        }
        return WordlistLoader.getWordtable(new File(path, wordfile));
    }

    public static HashMap getWordtable(String wordfile) {
        if (wordfile == null) {
            return new HashMap();
        }
        return WordlistLoader.getWordtable(new File(wordfile));
    }

    public static HashMap getStemDict(File wordstemfile) {
        if (wordstemfile == null) {
            return new HashMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String line;
            LineNumberReader lnr = new LineNumberReader(new FileReader(wordstemfile));
            while ((line = lnr.readLine()) != null) {
                String[] wordstem = line.split("\t", 2);
                result.put(wordstem[0], wordstem[1]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static HashMap getWordtable(File wordfile) {
        if (wordfile == null) {
            return new HashMap();
        }
        HashMap result = null;
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(wordfile));
            String word = null;
            String[] stopwords = new String[100];
            int wordcount = 0;
            while ((word = lnr.readLine()) != null) {
                if (++wordcount == stopwords.length) {
                    String[] tmp = new String[stopwords.length + 50];
                    System.arraycopy(stopwords, 0, tmp, 0, wordcount);
                    stopwords = tmp;
                }
                stopwords[wordcount - 1] = word;
            }
            result = WordlistLoader.makeWordTable(stopwords, wordcount);
        }
        catch (IOException e) {
            result = new HashMap();
        }
        return result;
    }

    private static HashMap makeWordTable(String[] words, int length) {
        HashMap<String, String> table = new HashMap<String, String>(length);
        for (int i = 0; i < length; ++i) {
            table.put(words[i], words[i]);
        }
        return table;
    }
}

