/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.views.detail;

import com.android.ide.eclipse.gltrace.GLProtoBuf;
import com.android.ide.eclipse.gltrace.model.GLCall;
import com.android.ide.eclipse.gltrace.model.GLTrace;
import com.android.ide.eclipse.gltrace.views.FitToCanvasAction;
import com.android.ide.eclipse.gltrace.views.SaveImageAction;
import com.android.ide.eclipse.gltrace.views.detail.ICallDetailProvider;
import com.android.ide.eclipse.gltrace.widgets.ImageCanvas;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class GlDrawCallDetailProvider
implements ICallDetailProvider {
    private ImageCanvas mImageCanvas;
    private FitToCanvasAction mFitToCanvasAction;
    private SaveImageAction mSaveImageAction;
    private List<IContributionItem> mToolBarItems;

    @Override
    public boolean isApplicable(GLCall call) {
        return (call.getFunction() == GLProtoBuf.GLMessage.Function.glDrawArrays || call.getFunction() == GLProtoBuf.GLMessage.Function.glDrawElements) && call.hasFb();
    }

    @Override
    public void createControl(Composite parent) {
        this.mImageCanvas = new ImageCanvas(parent);
        this.mImageCanvas.setFitToCanvas(false);
        this.mFitToCanvasAction = new FitToCanvasAction(false, this.mImageCanvas);
        this.mSaveImageAction = new SaveImageAction(this.mImageCanvas);
        this.mToolBarItems = Arrays.asList(new ActionContributionItem((IAction)this.mFitToCanvasAction), new ActionContributionItem((IAction)this.mSaveImageAction));
    }

    @Override
    public void disposeControl() {
        if (this.mImageCanvas != null) {
            this.mImageCanvas.dispose();
            this.mImageCanvas = null;
        }
    }

    @Override
    public Control getControl() {
        return this.mImageCanvas;
    }

    @Override
    public void updateControl(GLTrace trace, GLCall call) {
        this.mImageCanvas.setImage(trace.getImage(call));
        this.mImageCanvas.setFitToCanvas(true);
    }

    @Override
    public List<IContributionItem> getToolBarItems() {
        return this.mToolBarItems;
    }
}

