/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor;

import com.android.SdkConstants;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class SdkToolsLocator {
    public static final String PLATFORM_EXECUTABLE_EXTENSION = SdkConstants.CURRENT_PLATFORM == 2 ? ".exe" : "";
    public static final String PLATFORM_SCRIPT_EXTENSION = SdkConstants.CURRENT_PLATFORM == 2 ? ".bat" : "";
    public static final String FN_HPROF_CONV = "hprof-conv" + PLATFORM_EXECUTABLE_EXTENSION;
    public static final String FN_MONITOR = "monitor" + PLATFORM_SCRIPT_EXTENSION;
    private final File mSdkFolder;

    public SdkToolsLocator(File sdkFolder) {
        this.mSdkFolder = sdkFolder;
    }

    public String getAdbLocation() {
        return new File(this.getSdkPlatformToolsFolder(), SdkConstants.FN_ADB).getAbsolutePath();
    }

    public String getMonitorLocation() {
        return new File(this.getSdkToolsFolder(), FN_MONITOR).getAbsolutePath();
    }

    public String getHprofConvLocation() {
        return new File(this.getSdkPlatformToolsFolder(), FN_HPROF_CONV).getAbsolutePath();
    }

    private String getSdkToolsFolder() {
        return new File(this.mSdkFolder, "tools").getAbsolutePath();
    }

    private String getSdkPlatformToolsFolder() {
        return new File(this.mSdkFolder, "platform-tools").getAbsolutePath();
    }

    public SdkInstallStatus isValidInstallation() {
        List<String> executables = Arrays.asList(this.getMonitorLocation(), this.getHprofConvLocation());
        for (String exe : executables) {
            File f = new File(exe);
            if (!f.exists()) {
                return SdkInstallStatus.invalidInstallation(String.valueOf(exe) + " not present.");
            }
            if (f.canExecute()) continue;
            return SdkInstallStatus.invalidInstallation(String.valueOf(exe) + " is not executable.");
        }
        return SdkInstallStatus.VALID;
    }

    public static class SdkInstallStatus {
        private boolean mValid;
        private String mCause;
        public static final SdkInstallStatus VALID = new SdkInstallStatus(true, "");

        private SdkInstallStatus(boolean valid, String errorMessage) {
            this.mValid = valid;
            this.mCause = errorMessage;
        }

        public boolean isValid() {
            return this.mValid;
        }

        public String getErrorMessage() {
            return this.mCause;
        }

        public static SdkInstallStatus invalidInstallation(String errorMessage) {
            return new SdkInstallStatus(false, errorMessage);
        }
    }
}

