/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.systrace;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.google.common.primitives.Bytes;

public class SystraceTask
implements Runnable {
    private final IDevice mDevice;
    private final String mOptions;
    private volatile boolean mCancel;
    private final Object mLock = new Object();
    private String errorMessage;
    private boolean mTraceComplete;
    private byte[] mBuffer = new byte[1024];
    private int mDataLength = 0;

    public SystraceTask(IDevice device, String options) {
        this.mDevice = device;
        this.mOptions = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mDevice.executeShellCommand("atrace " + this.mOptions, (IShellOutputReceiver)new Receiver(), 0);
        }
        catch (Exception e) {
            Object object = this.mLock;
            synchronized (object) {
                this.errorMessage = "Unexpected error while running atrace on device: " + e;
            }
        }
    }

    public void cancel() {
        this.mCancel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getError() {
        Object object = this.mLock;
        synchronized (object) {
            return this.errorMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAtraceOutput() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mTraceComplete ? this.mBuffer : null;
        }
    }

    private class Receiver
    implements IShellOutputReceiver {
        private Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOutput(byte[] data, int offset, int length) {
            Object object = SystraceTask.this.mLock;
            synchronized (object) {
                if (SystraceTask.this.mDataLength + length > SystraceTask.this.mBuffer.length) {
                    SystraceTask.this.mBuffer = Bytes.ensureCapacity((byte[])SystraceTask.this.mBuffer, (int)(SystraceTask.this.mDataLength + length + 1), (int)1024);
                }
                int i = 0;
                while (i < length) {
                    ((SystraceTask)SystraceTask.this).mBuffer[((SystraceTask)SystraceTask.this).mDataLength + i] = data[offset + i];
                    ++i;
                }
                SystraceTask systraceTask = SystraceTask.this;
                systraceTask.mDataLength = systraceTask.mDataLength + length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() {
            Object object = SystraceTask.this.mLock;
            synchronized (object) {
                byte[] copy = new byte[SystraceTask.this.mDataLength];
                int i = 0;
                while (i < SystraceTask.this.mDataLength) {
                    copy[i] = SystraceTask.this.mBuffer[i];
                    ++i;
                }
                SystraceTask.this.mBuffer = copy;
                SystraceTask.this.mTraceComplete = true;
            }
        }

        public boolean isCancelled() {
            return SystraceTask.this.mCancel;
        }
    }
}

