/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;

public class SetJavaScriptEnabledDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create((String)"SetJavaScriptEnabled", (String)"Using `setJavaScriptEnabled`", (String)"Your code should not invoke `setJavaScriptEnabled` if you are not sure that your app really requires JavaScript support.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(SetJavaScriptEnabledDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/security.html");

    public void visitMethod(JavaContext context, UCallExpression call, PsiMethod method) {
        Object constant;
        List arguments = call.getValueArguments();
        if (arguments.size() == 1 && (constant = ConstantEvaluator.evaluate((JavaContext)context, (UElement)((UElement)arguments.get(0)))) != null && !Boolean.FALSE.equals(constant)) {
            context.report(ISSUE, (UElement)call, context.getLocation((UElement)call), "Using `setJavaScriptEnabled` can introduce XSS vulnerabilities into your application, review carefully.");
        }
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setJavaScriptEnabled");
    }
}

