/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RestrictionsDetector
extends ResourceXmlDetector {
    static final int MAX_NESTING_DEPTH = 20;
    static final int MAX_NUMBER_OF_NESTED_RESTRICTIONS = 1000;
    public static final Issue ISSUE = Issue.create((String)"ValidRestrictions", (String)"Invalid Restrictions Descriptor", (String)"Ensures that an applications restrictions XML file is properly formed", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.FATAL, (Implementation)new Implementation(RestrictionsDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://developer.android.com/reference/android/content/RestrictionsManager.html");
    static final String TAG_RESTRICTIONS = "restrictions";
    static final String TAG_RESTRICTION = "restriction";
    static final String ATTR_RESTRICTION_TYPE = "restrictionType";
    static final String ATTR_KEY = "key";
    static final String ATTR_DESCRIPTION = "description";
    static final String VALUE_BUNDLE = "bundle";
    static final String VALUE_BUNDLE_ARRAY = "bundle_array";
    static final String VALUE_CHOICE = "choice";
    static final String VALUE_MULTI_SELECT = "multi-select";
    static final String VALUE_ENTRIES = "entries";
    static final String VALUE_ENTRY_VALUES = "entryValues";
    static final String VALUE_HIDDEN = "hidden";
    static final String VALUE_DEFAULT_VALUE = "defaultValue";
    static final String VALUE_INTEGER = "integer";

    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.XML;
    }

    public void visitDocument(XmlContext context, Document document) {
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        if (!TAG_RESTRICTIONS.equals(root.getTagName())) {
            return;
        }
        HashMap keys = Maps.newHashMap();
        RestrictionsDetector.validateNestedRestrictions(context, root, null, keys, 0);
    }

    private static void validateNestedRestrictions(XmlContext context, Element element, String restrictionType, Map<String, Element> keys, int depth) {
        assert (depth == 0 || restrictionType != null);
        List children = LintUtils.getChildren((Node)element);
        if (depth == 0 || restrictionType.equals(VALUE_BUNDLE) || restrictionType.equals(VALUE_BUNDLE_ARRAY)) {
            Attr defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", VALUE_DEFAULT_VALUE);
            if (defaultValue != null) {
                context.report(ISSUE, (Node)element, context.getLocation((Node)defaultValue), String.format("Restriction type `%1$s` should not have a default value", restrictionType));
            }
            for (Element child : children) {
                if (!RestrictionsDetector.verifyRestrictionTagName(context, child)) continue;
                RestrictionsDetector.validateRestriction(context, child, depth + 1, keys);
            }
            if (depth != 0) {
                if (restrictionType.equals(VALUE_BUNDLE_ARRAY)) {
                    if (children.size() != 1) {
                        context.report(ISSUE, (Node)element, context.getLocation((Node)element), "Expected exactly one child for restriction of type `bundle_array`");
                    }
                } else {
                    assert (restrictionType.equals(VALUE_BUNDLE));
                    if (children.isEmpty()) {
                        context.report(ISSUE, (Node)element, context.getLocation((Node)element), "Restriction type `bundle` should have at least one nested restriction");
                    }
                }
            }
            if (children.size() > 1000) {
                context.report(ISSUE, (Node)element, context.getLocation((Node)element), String.format("Invalid nested restriction: too many nested restrictions (was %1$d, max %2$d)", children.size(), 1000));
            } else if (depth > 20) {
                context.report(ISSUE, (Node)element, context.getLocation((Node)element), String.format("Invalid nested restriction: nesting depth %1$d too large (max %2$d", depth, 20));
            }
        } else if (!children.isEmpty()) {
            context.report(ISSUE, (Node)element, context.getNameLocation((Node)element), "Only restrictions of type `bundle` and `bundle_array` can have one or multiple nested restriction elements");
        }
    }

    private static void validateRestriction(XmlContext context, Node node, int depth, Map<String, Element> keys) {
        Attr defaultValue;
        if (node.getNodeType() != 1) {
            return;
        }
        Element element = (Element)node;
        String restrictionType = RestrictionsDetector.checkRequiredAttribute(context, element, ATTR_RESTRICTION_TYPE);
        String key = RestrictionsDetector.checkRequiredAttribute(context, element, ATTR_KEY);
        String title = RestrictionsDetector.checkRequiredAttribute(context, element, "title");
        if (restrictionType == null || key == null || title == null) {
            return;
        }
        if (key.startsWith("@string/")) {
            Attr attribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Location valueLocation = context.getValueLocation(attribute);
            context.report(ISSUE, (Node)element, valueLocation, "Keys cannot be localized, they should be specified with a string literal");
        } else if (keys.containsKey(key)) {
            Attr thisAttribute = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Location location = context.getValueLocation(thisAttribute);
            Element prev = keys.get(key);
            Attr prevAttribute = prev.getAttributeNodeNS("http://schemas.android.com/apk/res/android", ATTR_KEY);
            Location previousLocation = context.getValueLocation(prevAttribute);
            previousLocation.setMessage("Previous use of key here");
            location.setSecondary(previousLocation);
            context.report(ISSUE, (Node)element, location, String.format("Duplicate key `%1$s`", key));
        } else {
            keys.put(key, element);
        }
        if (restrictionType.equals(VALUE_CHOICE) || restrictionType.equals(VALUE_MULTI_SELECT)) {
            boolean thisAttribute = RestrictionsDetector.checkRequiredAttribute(context, element, VALUE_ENTRIES) != null || RestrictionsDetector.checkRequiredAttribute(context, element, VALUE_ENTRY_VALUES) != null;
        } else if (restrictionType.equals(VALUE_HIDDEN)) {
            RestrictionsDetector.checkRequiredAttribute(context, element, VALUE_DEFAULT_VALUE);
        } else if (restrictionType.equals(VALUE_INTEGER) && (defaultValue = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", VALUE_DEFAULT_VALUE)) != null && !defaultValue.getValue().startsWith("@")) {
            try {
                Integer.decode(defaultValue.getValue());
            }
            catch (NumberFormatException e) {
                context.report(ISSUE, (Node)element, context.getValueLocation(defaultValue), "Invalid number");
            }
        }
        RestrictionsDetector.validateNestedRestrictions(context, element, restrictionType, keys, depth);
    }

    private static boolean verifyRestrictionTagName(XmlContext context, Element element) {
        String tagName = element.getTagName();
        if (!tagName.equals(TAG_RESTRICTION)) {
            context.report(ISSUE, (Node)element, context.getNameLocation((Node)element), String.format("Unexpected tag `<%1$s>`, expected `<%2$s>`", tagName, TAG_RESTRICTION));
            return false;
        }
        return true;
    }

    private static String checkRequiredAttribute(XmlContext context, Element element, String attribute) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", attribute)) {
            String prefix = element.getOwnerDocument().lookupNamespaceURI("http://schemas.android.com/apk/res/android");
            if (prefix == null) {
                Element root = element.getOwnerDocument().getDocumentElement();
                NamedNodeMap attributes = root.getAttributes();
                int n = attributes.getLength();
                for (int i = 0; i < n; ++i) {
                    Attr a = (Attr)attributes.item(i);
                    if (!a.getName().startsWith("xmlns:") || !"http://schemas.android.com/apk/res/android".equals(a.getValue())) continue;
                    prefix = a.getName().substring("xmlns:".length());
                    break;
                }
            }
            if (prefix != null) {
                attribute = prefix + ':' + attribute;
            }
            context.report(ISSUE, (Node)element, context.getLocation((Node)element), String.format("Missing required attribute `%1$s`", attribute));
            return null;
        }
        return element.getAttributeNS("http://schemas.android.com/apk/res/android", attribute);
    }
}

