/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastLiteralUtils;

public class ReadParcelableDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create((String)"ParcelClassLoader", (String)"Default Parcel Class Loader", (String)"The documentation for `Parcel#readParcelable(ClassLoader)` (and its variations) says that you can pass in `null` to pick up the default class loader. However, that ClassLoader is a system class loader and is not able to find classes in your own application.\n\nIf you are writing your own classes into the `Parcel` (not just SDK classes like `String` and so on), then you should supply a `ClassLoader` for your application instead; a simple way to obtain one is to just call `getClass().getClassLoader()` from your own class.", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(ReadParcelableDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcel.html");

    public List<String> getApplicableMethodNames() {
        return Arrays.asList("readParcelable", "readParcelableArray", "readBundle", "readArray", "readSparseArray", "readValue", "readPersistableBundle");
    }

    public void visitMethod(JavaContext context, UCallExpression node, PsiMethod method) {
        UExpression parameter;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (!"android.os.Parcel".equals(containingClass.getQualifiedName())) {
            return;
        }
        List expressions = node.getValueArguments();
        int argumentCount = expressions.size();
        if (argumentCount == 0) {
            String message = String.format("Using the default class loader will not work if you are restoring your own classes. Consider using for example `%1$s(getClass().getClassLoader())` instead.", node.getMethodName());
            LintFix fix = ReadParcelableDetector.createQuickfixData(")");
            Location location = context.getCallLocation(node, false, true);
            context.report(ISSUE, (UElement)node, location, message, fix);
        } else if (argumentCount == 1 && UastLiteralUtils.isNullLiteral((UElement)(parameter = (UExpression)expressions.get(0)))) {
            String message = "Passing null here (to use the default class loader) will not work if you are restoring your own classes. Consider using for example `getClass().getClassLoader()` instead.";
            Location location = context.getCallLocation(node, false, true);
            LintFix fix = ReadParcelableDetector.createQuickfixData("null)");
            context.report(ISSUE, (UElement)node, location, message, fix);
        }
    }

    private static LintFix createQuickfixData(String parameter) {
        return ReadParcelableDetector.fix().name("Use getClass().getClassLoader()").replace().text(parameter).with("getClass().getClassLoader())").build();
    }
}

