/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import java.io.File;

@Beta
public class ResourceContext
extends Context {
    private final ResourceFolderType folderType;
    private FolderConfiguration folderConfiguration;

    public ResourceContext(LintDriver driver, Project project, Project main, File file, ResourceFolderType folderType, String contents) {
        super(driver, project, main, file, contents);
        this.folderType = folderType;
    }

    public ResourceFolderType getResourceFolderType() {
        return this.folderType;
    }

    public int getFolderVersion() {
        VersionQualifier versionQualifier;
        if (this.getFolderConfiguration() != null && (versionQualifier = this.getFolderConfiguration().getVersionQualifier()) != null) {
            return versionQualifier.getVersion();
        }
        return -1;
    }

    public FolderConfiguration getFolderConfiguration() {
        File folder;
        if (this.folderConfiguration == null && this.folderType != null && (folder = this.getResourceFolder()) != null) {
            this.folderConfiguration = FolderConfiguration.getConfigForFolder((String)folder.getName());
        }
        return this.folderConfiguration;
    }

    protected File getResourceFolder() {
        return this.folderType != null ? this.file : null;
    }
}

