/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.functions.Function;
import com.google.clearsilver.jsilver.functions.FunctionExecutor;
import com.google.clearsilver.jsilver.functions.TextFilter;
import com.google.clearsilver.jsilver.values.Value;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class FunctionRegistry
implements FunctionExecutor {
    protected Map<String, Function> functions = new HashMap<String, Function>();
    protected Map<String, TextFilter> escapers = new HashMap<String, TextFilter>();

    public FunctionRegistry() {
        this.setupDefaultFunctions();
    }

    public Value executeFunction(String name, Value ... args) {
        Function function = this.functions.get(name);
        if (function == null) {
            throw new JSilverInterpreterException("Function not found " + name);
        }
        Value result = function.execute(args);
        if (result == null) {
            throw new JSilverInterpreterException("Function " + name + " did not return value");
        }
        return result;
    }

    public void escape(String name, String input, Appendable output) throws IOException {
        if (name == null || name.isEmpty() || name.equals("none")) {
            output.append(input);
        } else {
            TextFilter escaper = this.escapers.get(name);
            if (escaper == null) {
                throw new JSilverInterpreterException("Unknown escaper: " + name);
            }
            escaper.filter(input, output);
        }
    }

    public boolean isEscapingFunction(String name) {
        Function function = this.functions.get(name);
        if (function == null) {
            throw new JSilverInterpreterException("Function not found " + name);
        }
        return function.isEscapingFunction();
    }

    protected void setupDefaultFunctions() {
    }

    public void registerFunction(String name, Function function) {
        this.functions.put(name, function);
    }

    public void registerFunction(String name, TextFilter textFilter) {
        this.registerFunction(name, textFilter, false);
    }

    public void registerFunction(String name, final TextFilter textFilter, final boolean isEscaper) {
        this.registerFunction(name, new Function(){

            public Value execute(Value ... args) {
                boolean isPartiallyEscaped;
                EscapeMode mode;
                if (args.length != 1) {
                    throw new IllegalArgumentException("Expected 1 argument");
                }
                String in = args[0].asString();
                StringBuilder out = new StringBuilder(in.length());
                try {
                    textFilter.filter(in, out);
                }
                catch (IOException e) {
                    throw new JSilverInterpreterException(e.getMessage());
                }
                if (isEscaper) {
                    mode = EscapeMode.ESCAPE_IS_CONSTANT;
                    isPartiallyEscaped = true;
                } else {
                    mode = EscapeMode.ESCAPE_NONE;
                    isPartiallyEscaped = false;
                    for (Value arg : args) {
                        if (!arg.isPartiallyEscaped()) continue;
                        isPartiallyEscaped = true;
                        break;
                    }
                }
                return Value.literalValue(out.toString(), mode, isPartiallyEscaped);
            }

            public boolean isEscapingFunction() {
                return isEscaper;
            }
        });
    }

    public void registerEscapeMode(String name, TextFilter escaper) {
        this.escapers.put(name, escaper);
    }
}

