/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.compiler.ExpressionTranslator;
import com.google.clearsilver.jsilver.compiler.JavaExpression;
import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.ADecNumberVariable;
import com.google.clearsilver.jsilver.syntax.node.ADescendVariable;
import com.google.clearsilver.jsilver.syntax.node.AExpandVariable;
import com.google.clearsilver.jsilver.syntax.node.AHexNumberVariable;
import com.google.clearsilver.jsilver.syntax.node.ANameVariable;
import com.google.clearsilver.jsilver.syntax.node.PVariable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableTranslator
extends DepthFirstAdapter {
    private List<JavaExpression> components;
    private final ExpressionTranslator expressionTranslator;
    private static final JavaExpression DOT = new JavaExpression.StringExpression(".");

    public VariableTranslator(ExpressionTranslator expressionTranslator) {
        this.expressionTranslator = expressionTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaExpression translate(PVariable csVariable) {
        try {
            assert (this.components == null);
            this.components = new ArrayList<JavaExpression>();
            csVariable.apply(this);
            this.components = this.joinComponentsWithDots(this.components);
            this.components = this.combineAdjacentStrings(this.components);
            JavaExpression javaExpression = this.concatenate(this.components);
            return javaExpression;
        }
        finally {
            this.components = null;
        }
    }

    @Override
    public void caseANameVariable(ANameVariable node) {
        this.components.add(new JavaExpression.StringExpression(node.getWord().getText()));
    }

    @Override
    public void caseADecNumberVariable(ADecNumberVariable node) {
        this.components.add(new JavaExpression.StringExpression(node.getDecNumber().getText()));
    }

    @Override
    public void caseAHexNumberVariable(AHexNumberVariable node) {
        this.components.add(new JavaExpression.StringExpression(node.getHexNumber().getText()));
    }

    @Override
    public void caseADescendVariable(ADescendVariable node) {
        node.getParent().apply(this);
        node.getChild().apply(this);
    }

    @Override
    public void caseAExpandVariable(AExpandVariable node) {
        node.getParent().apply(this);
        this.components.add(this.expressionTranslator.translateToString(node.getChild()));
    }

    private List<JavaExpression> joinComponentsWithDots(List<JavaExpression> in) {
        ArrayList<JavaExpression> out = new ArrayList<JavaExpression>(in.size() * 2);
        for (JavaExpression component : in) {
            if (!out.isEmpty()) {
                out.add(DOT);
            }
            out.add(component);
        }
        return out;
    }

    private List<JavaExpression> combineAdjacentStrings(List<JavaExpression> in) {
        assert (!in.isEmpty());
        ArrayList<JavaExpression> out = new ArrayList<JavaExpression>(in.size());
        JavaExpression last = null;
        for (JavaExpression current : in) {
            if (last == null) {
                last = current;
                continue;
            }
            if (current instanceof JavaExpression.StringExpression && last instanceof JavaExpression.StringExpression) {
                JavaExpression.StringExpression currentString = (JavaExpression.StringExpression)current;
                JavaExpression.StringExpression lastString = (JavaExpression.StringExpression)last;
                last = new JavaExpression.StringExpression(lastString.getValue() + currentString.getValue());
                continue;
            }
            out.add(last);
            last = current;
        }
        out.add(last);
        return out;
    }

    private JavaExpression concatenate(List<JavaExpression> expressions) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        boolean seenFirst = false;
        for (JavaExpression expression : expressions) {
            if (seenFirst) {
                out.print(" + ");
            }
            seenFirst = true;
            expression.write(out);
        }
        return JavaExpression.literal(JavaExpression.Type.VAR_NAME, buffer.toString());
    }
}

