/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.optimizer;

import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.optimizer.ConstantPool;

public class ModuleConstantsCollector
extends ModuleVisitor {
    private final ConstantPool cp;

    public ModuleConstantsCollector(ModuleVisitor mv, ConstantPool cp) {
        super(393216, mv);
        this.cp = cp;
    }

    public void visitMainClass(String mainClass) {
        this.cp.newUTF8("ModuleMainClass");
        this.cp.newUTF8(mainClass);
        this.mv.visitMainClass(mainClass);
    }

    public void visitTarget(String osName, String osArch, String osVersion) {
        this.cp.newUTF8("ModuleTarget");
        this.cp.newUTF8(osName);
        this.cp.newUTF8(osArch);
        this.cp.newUTF8(osVersion);
        super.visitTarget(osName, osArch, osVersion);
    }

    public void visitPackage(String packaze) {
        this.cp.newUTF8("ModulePackages");
        this.cp.newUTF8(packaze);
        super.visitPackage(packaze);
    }

    public void visitRequire(String module, int access, String version) {
        this.cp.newModule(module);
        this.cp.newUTF8(version);
        this.mv.visitRequire(module, access, version);
    }

    public void visitExport(String packaze, int access, String ... modules) {
        this.cp.newPackage(packaze);
        if (modules != null && modules.length > 0) {
            for (String module : modules) {
                this.cp.newModule(module);
            }
        }
        this.mv.visitExport(packaze, access, modules);
    }

    public void visitOpen(String packaze, int access, String ... modules) {
        this.cp.newPackage(packaze);
        if (modules != null && modules.length > 0) {
            for (String module : modules) {
                this.cp.newModule(module);
            }
        }
        this.mv.visitOpen(packaze, access, modules);
    }

    public void visitUse(String service) {
        this.cp.newClass(service);
        this.mv.visitUse(service);
    }

    public void visitProvide(String service, String ... providers) {
        this.cp.newClass(service);
        for (String provider : providers) {
            this.cp.newClass(provider);
        }
        this.mv.visitProvide(service, providers);
    }

    public void visitEnd() {
        this.mv.visitEnd();
    }
}

