/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.TableViewModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jetbrains.annotations.NotNull;

public class ListTableModel<Item>
extends TableViewModel<Item>
implements EditableModel {
    private ColumnInfo[] myColumnInfos;
    private List<Item> myItems;
    private int mySortByColumn;
    private boolean myIsSortable;
    private SortOrder mySortOrder;

    public ListTableModel(ColumnInfo ... columnInfos) {
        if (columnInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnInfos", "com/intellij/util/ui/ListTableModel", "<init>"));
        }
        this(columnInfos, new ArrayList(), 0, SortOrder.ASCENDING);
    }

    public ListTableModel(@NotNull ColumnInfo[] columnNames, @NotNull List<Item> items, int selectedColumn) {
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/util/ui/ListTableModel", "<init>"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/ListTableModel", "<init>"));
        }
        this(columnNames, items, selectedColumn, SortOrder.ASCENDING);
    }

    public ListTableModel(@NotNull ColumnInfo[] columnNames, @NotNull List<Item> items) {
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/util/ui/ListTableModel", "<init>"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/ListTableModel", "<init>"));
        }
        this(columnNames, items, 0);
    }

    public ListTableModel(@NotNull ColumnInfo[] columnNames, @NotNull List<Item> items, int selectedColumn, @NotNull SortOrder order) {
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/util/ui/ListTableModel", "<init>"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/ListTableModel", "<init>"));
        }
        if (order == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "order", "com/intellij/util/ui/ListTableModel", "<init>"));
        }
        this.myIsSortable = false;
        this.mySortOrder = SortOrder.ASCENDING;
        this.myColumnInfos = columnNames;
        this.myItems = items;
        this.mySortByColumn = selectedColumn;
        this.mySortOrder = order;
        this.setSortable(ContainerUtil.find(columnNames, new Condition<ColumnInfo>(){

            @Override
            public boolean value(ColumnInfo columnInfo) {
                return columnInfo.isSortable();
            }
        }) != null);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myColumnInfos[columnIndex].isCellEditable(this.myItems.get(rowIndex));
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.myColumnInfos[columnIndex].getColumnClass();
    }

    @Override
    public ColumnInfo[] getColumnInfos() {
        return this.myColumnInfos;
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumnInfos[column].getName();
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    public RowSorter.SortKey getDefaultSortKey() {
        if (this.mySortByColumn != -1) {
            return new RowSorter.SortKey(this.mySortByColumn, this.mySortOrder);
        }
        return null;
    }

    public Item getRowValue(int row) {
        return this.myItems.get(row);
    }

    @Override
    public int getColumnCount() {
        return this.myColumnInfos.length;
    }

    @Override
    public void setItems(@NotNull List<Item> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/ListTableModel", "setItems"));
        }
        this.myItems = items;
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myColumnInfos[columnIndex].valueOf(this.getItem(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAt(aValue, rowIndex, columnIndex, true);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex, boolean notifyListeners) {
        if (rowIndex < this.myItems.size()) {
            this.myColumnInfos[columnIndex].setValue(this.getItem(rowIndex), aValue);
        }
        if (notifyListeners) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public boolean setColumnInfos(ColumnInfo[] columnInfos) {
        if (this.myColumnInfos != null && Arrays.equals(columnInfos, this.myColumnInfos)) {
            return false;
        }
        this.mySortByColumn = -1;
        this.myColumnInfos = columnInfos;
        this.fireTableStructureChanged();
        return true;
    }

    @Override
    @NotNull
    public List<Item> getItems() {
        List<Item> list = Collections.unmodifiableList(this.myItems);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ListTableModel", "getItems"));
        }
        return list;
    }

    protected Object getAspectOf(int aspectIndex, Object item) {
        return this.myColumnInfos[aspectIndex].valueOf(item);
    }

    @Override
    public void setSortable(boolean aBoolean) {
        this.myIsSortable = aBoolean;
    }

    @Override
    public boolean isSortable() {
        return this.myIsSortable;
    }

    public int indexOf(Item item) {
        return this.myItems.indexOf(item);
    }

    @Override
    public void addRow() {
    }

    @Override
    public void removeRow(int idx) {
        this.myItems.remove(idx);
        this.fireTableRowsDeleted(idx, idx);
    }

    @Override
    public void exchangeRows(int idx1, int idx2) {
        Collections.swap(this.myItems, idx1, idx2);
        if (idx1 < idx2) {
            this.fireTableRowsUpdated(idx1, idx2);
        } else {
            this.fireTableRowsUpdated(idx2, idx1);
        }
    }

    @Override
    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    public void addRow(Item item) {
        this.myItems.add(item);
        this.fireTableRowsInserted(this.myItems.size() - 1, this.myItems.size() - 1);
    }

    public void insertRow(int index, Item item) {
        this.myItems.add(index, item);
        this.fireTableRowsInserted(index, index);
    }

    public void addRows(@NotNull Collection<Item> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/ListTableModel", "addRows"));
        }
        this.myItems.addAll(items);
        if (!this.myItems.isEmpty()) {
            this.fireTableRowsInserted(this.myItems.size() - items.size(), this.myItems.size() - 1);
        }
    }

    public Item getItem(int rowIndex) {
        return this.myItems.get(rowIndex);
    }
}

