/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/psi/stubs/IStubElementType", "<init>"));
        }
        super(debugName, language);
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    public String getId(@NotNull StubT stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/stubs/IStubElementType", "getId"));
        }
        assert (stub.getStubType() == this);
        StubElement parent = stub.getParentStub();
        int count = 0;
        for (StubElement child : parent.getChildrenStubs()) {
            if (child.getStubType() == this) {
                ++count;
            }
            if (child != stub) continue;
            return '#' + String.valueOf(count);
        }
        throw new RuntimeException("Parent/child relations corrupted");
    }
}

