/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Disposer {
    private static final ObjectTree<Disposable> ourTree;
    private static final ObjectTreeAction<Disposable> ourDisposeAction;
    private static final String debugDisposer;
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    public static boolean isDebugDisposerOn() {
        return "on".equals(debugDisposer);
    }

    private Disposer() {
    }

    @NotNull
    public static Disposable newDisposable() {
        Disposable disposable = Disposer.newDisposable(null);
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Disposer", "newDisposable"));
        }
        return disposable;
    }

    @NotNull
    public static Disposable newDisposable(final @Nullable String debugName) {
        Disposable disposable = new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName == null ? super.toString() : debugName;
            }
        };
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Disposer", "newDisposable"));
        }
        return disposable;
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/Disposer", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/Disposer", "register"));
        }
        Disposer.register(parent, child, null);
    }

    public static void register(@NotNull Disposable parent, @NotNull Disposable child, final @NonNls @Nullable String key) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/Disposer", "register"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/openapi/util/Disposer", "register"));
        }
        ourTree.register(parent, child);
        if (key != null) {
            Disposable v = Disposer.get(key);
            if (v != null) {
                throw new IllegalArgumentException("Key " + key + " already registered: " + v);
            }
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                @Override
                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static boolean isDisposed(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/util/Disposer", "isDisposed"));
        }
        return ourTree.getDisposalInfo(disposable) != null;
    }

    public static Disposable get(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/Disposer", "get"));
        }
        return ourKeyDisposables.get(key);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/util/Disposer", "dispose"));
        }
        Disposer.dispose(disposable, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/util/Disposer", "dispose"));
        }
        ourTree.executeAll(disposable, ourDisposeAction, processUnregistered);
    }

    public static void disposeChildAndReplace(@NotNull Disposable toDispose, @NotNull Disposable toReplace) {
        if (toDispose == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toDispose", "com/intellij/openapi/util/Disposer", "disposeChildAndReplace"));
        }
        if (toReplace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toReplace", "com/intellij/openapi/util/Disposer", "disposeChildAndReplace"));
        }
        ourTree.executeChildAndReplace(toDispose, toReplace, ourDisposeAction);
    }

    @NotNull
    public static ObjectTree<Disposable> getTree() {
        ObjectTree<Disposable> objectTree = ourTree;
        if (objectTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Disposer", "getTree"));
        }
        return objectTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean isEmpty() {
        return ourDebugMode && ourTree.isEmpty();
    }

    public static boolean setDebugMode(boolean debugMode) {
        if (debugMode) {
            debugMode = !"off".equals(debugDisposer);
        }
        boolean oldValue = ourDebugMode;
        ourDebugMode = debugMode;
        return oldValue;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static void clearOwnFields(@Nullable Object object, @NotNull Condition<? super Field> selectCondition) {
        if (selectCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectCondition", "com/intellij/openapi/util/Disposer", "clearOwnFields"));
        }
        if (object == null) {
            return;
        }
        for (Field each : ReflectionUtil.collectFields(object.getClass())) {
            if ((each.getModifiers() & 0x18) > 0 || !selectCondition.value(each)) continue;
            try {
                ReflectionUtil.resetField(object, each);
            }
            catch (Exception exception) {}
        }
    }

    @Nullable
    public static <T extends Disposable> T findRegisteredObject(@NotNull Disposable parentDisposable, @NotNull T object) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/util/Disposer", "findRegisteredObject"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/openapi/util/Disposer", "findRegisteredObject"));
        }
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    static {
        try {
            ourTree = new ObjectTree();
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("loader=" + Disposer.class.getClassLoader(), e);
        }
        ourDisposeAction = new ObjectTreeAction<Disposable>(){

            @Override
            public void execute(@NotNull Disposable each) {
                if (each == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/intellij/openapi/util/Disposer$1", "execute"));
                }
                each.dispose();
            }

            @Override
            public void beforeTreeExecution(@NotNull Disposable parent) {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/util/Disposer$1", "beforeTreeExecution"));
                }
                if (parent instanceof Disposable.Parent) {
                    ((Disposable.Parent)parent).beforeTreeDispose();
                }
            }
        };
        debugDisposer = System.getProperty("idea.disposer.debug");
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }
}

